/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.permissions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.jguard.core.authorization.permissions.URLParameter;
import net.sf.jguard.core.authorization.permissions.URLPermission;
import org.apache.commons.lang.StringEscapeUtils;

public class URLParameterCollection
implements Serializable {
    private static final long serialVersionUID = -6533685803360570616L;
    private Set parameters = new HashSet();
    private boolean impliesMissingKeyParameters = false;

    public void add(URLParameter parameter) {
        this.parameters.add(parameter);
    }

    public boolean implies(URLParameter impliedParameter) {
        Iterator itParameter = this.parameters.iterator();
        while (itParameter.hasNext()) {
            URLParameter parameter = (URLParameter)itParameter.next();
            if (!parameter.impliesKey(impliedParameter.getKey())) continue;
            return parameter.impliesValues(impliedParameter.getValue());
        }
        return this.impliesMissingKeyParameters;
    }

    public boolean getImpliesMissingKeyParameters() {
        return this.impliesMissingKeyParameters;
    }

    public void setImpliesMissingKeyParameters(boolean impliesMissingKeyParameters) {
        this.impliesMissingKeyParameters = impliesMissingKeyParameters;
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    protected static URLParameterCollection getURLParameters(String strParams) {
        URLParameterCollection parametersCollection = new URLParameterCollection();
        if ((strParams = StringEscapeUtils.unescapeHtml((String)strParams)) != null && strParams != "") {
            List<String> tokens = Arrays.asList(strParams.split("&"));
            Iterator<String> itTokens = tokens.iterator();
            while (itTokens.hasNext()) {
                String token = itTokens.next();
                String[] parts = token.split("=");
                if (parts.length == 2) {
                    URLParameter param = new URLParameter();
                    param.setKey(URLPermission.buildRegexpFromString(parts[0]));
                    String[] values = parts[1].split(";");
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = URLPermission.buildRegexpFromString(values[i]);
                    }
                    param.setValue(values);
                    parametersCollection.add(param);
                    continue;
                }
                if (parts.length != 1 || !"*".equals(parts[0])) continue;
                parametersCollection.setImpliesMissingKeyParameters(true);
            }
        }
        return parametersCollection;
    }

    public int size() {
        return this.parameters.size();
    }

    public Collection getParameters() {
        return this.parameters;
    }

    public String toString() {
        Iterator itParameters = this.parameters.iterator();
        int count = 0;
        StringBuffer sb = new StringBuffer();
        while (itParameters.hasNext()) {
            URLParameter param = (URLParameter)itParameters.next();
            sb.append(" param").append(++count).append('=');
            sb.append(param.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

