/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.permissions;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class URLParameter
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3835156176932384821L;
    private String key = null;
    private String[] value = null;
    private String permissionName = null;

    protected URLParameter() {
    }

    public Object clone() throws CloneNotSupportedException {
        URLParameter param = new URLParameter();
        param.setKey(new String(this.key));
        param.setValue(this.value);
        param.setPermissionName(new String(this.permissionName));
        return param;
    }

    protected String getKey() {
        return this.key;
    }

    protected String[] getValue() {
        return this.value;
    }

    protected String getValuesAsString() {
        String[] valuesArray = this.value;
        StringBuffer concatValues = new StringBuffer();
        for (int i = 0; i < valuesArray.length; ++i) {
            if (i != 0) {
                concatValues.append(";");
            }
            concatValues.append(valuesArray[i]);
        }
        return concatValues.toString();
    }

    protected void setKey(String string) {
        this.key = string;
    }

    protected void setValue(String[] string) {
        this.value = string;
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer(this.key);
        sb.append(this.getValuesAsString());
        return sb.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URLParameter)) {
            return false;
        }
        URLParameter urlp = (URLParameter)obj;
        if (!urlp.getKey().equals(this.key)) {
            return false;
        }
        Object[] myArray = this.value;
        Object[] targetArray = urlp.getValue();
        if (myArray.length != targetArray.length) {
            return false;
        }
        Arrays.sort(targetArray);
        Arrays.sort(myArray);
        for (int i = 0; i < myArray.length; ++i) {
            if (((String)myArray[i]).equals(targetArray[i])) continue;
            return false;
        }
        return true;
    }

    protected String getPermissionName() {
        return this.permissionName;
    }

    protected void setPermissionName(String string) {
        this.permissionName = string;
    }

    protected static Set getURLParameters(URI uri) {
        HashSet<URLParameter> parameters = new HashSet<URLParameter>();
        String query = uri.getQuery();
        if ((query = StringEscapeUtils.unescapeHtml((String)query)) != null && query != "") {
            List<String> tokens = Arrays.asList(query.split("&"));
            Iterator<String> itTokens = tokens.iterator();
            while (itTokens.hasNext()) {
                String token = itTokens.next();
                String[] parts = token.split("=");
                if (parts.length != 2) continue;
                URLParameter param = new URLParameter();
                param.setKey(parts[0]);
                String[] values = parts[1].split(";");
                param.setValue(values);
                parameters.add(param);
            }
        }
        return parameters;
    }

    public boolean impliesKey(String key) {
        String regexpKey = this.key.replaceAll("\\*", "\\.\\*");
        return key.equals(this.key) || Pattern.matches(regexpKey, key);
    }

    public boolean impliesValues(String[] value) {
        if (value.length != this.value.length) {
            return false;
        }
        Arrays.sort(value);
        Arrays.sort(this.value);
        for (int i = 0; i < value.length; ++i) {
            String regexpValue = this.value[i].replaceAll("\\*", "\\.\\*");
            if (value[i].equals(this.value[i]) || Pattern.matches(regexpValue, value[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("key=").append(this.key).append("  ");
        sb.append("value=").append(this.getValuesAsString());
        return sb.toString();
    }
}

