/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.permissions;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.jguard.core.authorization.permissions.JGPositivePermissionCollection;
import net.sf.jguard.core.principals.RolePrincipal;
import net.sf.jguard.core.principals.UserPrincipal;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class PermissionUtils {
    private static final Logger logger = Logger.getLogger(PermissionUtils.class.getName());
    private static CacheManager manager;
    private static Cache unresolvedPermToNeededExpressions;
    private static Cache unresolvedPermAndValuesToResolvedPerm;
    private static boolean cachesEnabled;
    private static Pattern JEXL_PATTERN;

    public static Permission getPermission(String className, String name, String actions) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e1) {
            logger.log(Level.SEVERE, " class " + className + " is not found please check your classPath \n and the permission set in the Datasource \n(either database or JGuardPrincipalsPermissions.xml file) ", e1);
            throw e1;
        }
        Class[] permArgsBasicPermClass = new Class[]{String.class, String.class};
        Class[] permArgsPermClass = new Class[]{String.class};
        Object[] objBasicArray = new Object[]{name, actions};
        Permission newPerm = null;
        try {
            if (clazz.isAssignableFrom(BasicPermission.class)) {
                newPerm = (Permission)clazz.getConstructor(permArgsBasicPermClass).newInstance(objBasicArray);
                return newPerm;
            }
            Object[] objArray = new Object[]{name};
            Constructor<?>[] constructors = clazz.getConstructors();
            boolean constructorWithActions = false;
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> tempConstructor = constructors[i];
                Class<?>[] classes = tempConstructor.getParameterTypes();
                if (classes.length != 2 || !classes[0].equals(class$java$lang$String == null ? PermissionUtils.class$("java.lang.String") : class$java$lang$String) || !classes[1].equals(class$java$lang$String == null ? PermissionUtils.class$("java.lang.String") : class$java$lang$String)) continue;
                constructorWithActions = true;
                break;
            }
            newPerm = constructorWithActions ? (Permission)clazz.getConstructor(permArgsBasicPermClass).newInstance(objBasicArray) : (Permission)clazz.getConstructor(permArgsPermClass).newInstance(objArray);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, " illegal argument ", e);
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, "className=" + className);
            logger.log(Level.SEVERE, "name=" + name);
            logger.log(Level.SEVERE, "actions=" + actions);
            logger.log(Level.SEVERE, " you don't have right to instantiate a permission ", e);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "className=" + className);
            logger.log(Level.SEVERE, "name=" + name);
            logger.log(Level.SEVERE, "actions=" + actions);
            logger.log(Level.SEVERE, " you cannot instantiate a permission ", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "className=" + className);
            logger.log(Level.SEVERE, "name=" + name);
            logger.log(Level.SEVERE, "actions=" + actions);
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.SEVERE, "className=" + className);
            logger.log(Level.SEVERE, "name=" + name);
            logger.log(Level.SEVERE, "actions=" + actions);
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, "method not found =", e);
        }
        return newPerm;
    }

    private static boolean evaluateDefinition(String jexlExpression, UserPrincipal userPrincipal) {
        String PRIVATE_CREDENTIALS = "subject.privateCredentials";
        String PUBLIC_CREDENTIALS = "subject.publicCredentials";
        String ROLES = "subject.roles";
        String ORGANIZATION = "subject.organization";
        if (jexlExpression == null) {
            return false;
        }
        if ("true".equalsIgnoreCase(jexlExpression)) {
            return true;
        }
        if ("false".equalsIgnoreCase(jexlExpression)) {
            return false;
        }
        if (jexlExpression != null && userPrincipal == null) {
            logger.warning("evaluateDefinition() no UserPrincipal defined, can not use regex definition");
        }
        jexlExpression = jexlExpression.substring(2, jexlExpression.length() - 1);
        JexlContext jexlContext = JexlHelper.createContext();
        jexlContext.getVars().put("subject.organization", userPrincipal.getOrganization());
        jexlContext.getVars().put("subject.roles", userPrincipal.getRoles());
        jexlContext.getVars().put("subject.publicCredentials", userPrincipal.getPublicCredentials());
        jexlContext.getVars().put("subject.privateCredentials", userPrincipal.getPrivateCredentials());
        Object resolvedExpression = null;
        try {
            Expression expression = ExpressionFactory.createExpression((String)jexlExpression);
            resolvedExpression = expression.evaluate(jexlContext);
        }
        catch (Exception e) {
            logger.warning("Failed to evaluate : " + jexlExpression);
        }
        if (resolvedExpression == null || !(resolvedExpression instanceof Boolean)) {
            logger.warning("Subject does not have the required credentials to resolve the role activation : " + jexlExpression);
            return false;
        }
        Boolean val = (Boolean)resolvedExpression;
        return val;
    }

    public static boolean evaluatePrincipal(RolePrincipal ppal, UserPrincipal userPrincipal) {
        if (!PermissionUtils.evaluateDefinition(ppal.getDefinition(), userPrincipal)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("evaluatePrincipal() -  user's principal definition attr evaluates to false=" + ppal.getLocalName());
            }
            return false;
        }
        if (!ppal.isActive()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("evaluatePrincipal() -  user's principal active attr is false=" + ppal.getLocalName());
            }
            return false;
        }
        return true;
    }

    public static PermissionCollection evaluatePermissionCollection(ProtectionDomain protectionDomain, PermissionCollection pc) {
        int i;
        String PRIVATE_CREDENTIALS = "subject.privateCredentials";
        String PUBLIC_CREDENTIALS = "subject.publicCredentials";
        String SUBJECT_ROLES = "subject.roles";
        Principal[] ppals = protectionDomain.getPrincipals();
        boolean hasJexlPrincipal = false;
        for (i = 0; !hasJexlPrincipal && i < ppals.length; ++i) {
            hasJexlPrincipal = ppals[i] instanceof UserPrincipal;
        }
        if (!hasJexlPrincipal) {
            logger.warning("no UserPrincipal defined, can not use regex permissions");
            return pc;
        }
        JGPositivePermissionCollection resolvedPc = new JGPositivePermissionCollection();
        UserPrincipal subjectPrincipal = (UserPrincipal)ppals[i - 1];
        JexlContext jc = JexlHelper.createContext();
        Map vars = jc.getVars();
        vars.put("subject.roles", subjectPrincipal.getRoles());
        vars.put("subject.publicCredentials", subjectPrincipal.getPublicCredentials());
        vars.put("subject.privateCredentials", subjectPrincipal.getPrivateCredentials());
        Enumeration<Permission> permissionsEnum = pc.elements();
        HashMap subjectResolvedExpressions = new HashMap();
        while (permissionsEnum.hasMoreElements()) {
            Permission permission = permissionsEnum.nextElement();
            logger.finest("Resolving permission = " + permission);
            PermissionCollection pcFromPermission = PermissionUtils.resolvePermission(permission, subjectResolvedExpressions, jc);
            Enumeration<Permission> enumPermissions = pcFromPermission.elements();
            while (enumPermissions.hasMoreElements()) {
                Permission p = enumPermissions.nextElement();
                ((PermissionCollection)resolvedPc).add(p);
            }
        }
        return resolvedPc;
    }

    private static HashSet createKey(Permission unresolvedPermission, Map values) {
        HashSet<Object> key = new HashSet<Object>();
        key.add(unresolvedPermission);
        key.add(values);
        return key;
    }

    private static PermissionCollection resolvePermission(Permission permission, Map subjectResolvedExpressions, JexlContext jexlContext) {
        JGPositivePermissionCollection resolvedPermissions;
        block28: {
            resolvedPermissions = new JGPositivePermissionCollection();
            if (cachesEnabled) {
                try {
                    Element expressionsCacheEntry = unresolvedPermToNeededExpressions.get((Serializable)permission);
                    if (expressionsCacheEntry == null) break block28;
                    Set neededExpressions = (Set)((Object)expressionsCacheEntry.getValue());
                    if (neededExpressions.isEmpty()) {
                        ((PermissionCollection)resolvedPermissions).add(permission);
                        logger.finest("get permission from cache with no resolution needed");
                        return resolvedPermissions;
                    }
                    Iterator itExpressions = neededExpressions.iterator();
                    HashMap<String, Object> permissionResolvedExpressions = new HashMap<String, Object>();
                    boolean hasNull = false;
                    while (itExpressions.hasNext()) {
                        String jexlExpression = (String)itExpressions.next();
                        Object resolvedExpression = null;
                        if (subjectResolvedExpressions.containsKey(jexlExpression)) {
                            resolvedExpression = subjectResolvedExpressions.get(jexlExpression);
                            permissionResolvedExpressions.put(jexlExpression, resolvedExpression);
                        } else {
                            try {
                                Expression expression = ExpressionFactory.createExpression((String)jexlExpression);
                                resolvedExpression = expression.evaluate(jexlContext);
                                subjectResolvedExpressions.put(jexlExpression, resolvedExpression);
                                permissionResolvedExpressions.put(jexlExpression, resolvedExpression);
                            }
                            catch (Exception e) {
                                logger.warning("Failed to evaluate : " + jexlExpression);
                            }
                        }
                        if (resolvedExpression != null && (!(resolvedExpression instanceof List) || !((List)resolvedExpression).isEmpty())) continue;
                        hasNull = true;
                        break;
                    }
                    if (hasNull) {
                        logger.warning("Subject does not have the required credentials to resolve the permission : " + permission);
                        ((PermissionCollection)resolvedPermissions).add(permission);
                        return resolvedPermissions;
                    }
                    HashSet key = PermissionUtils.createKey(permission, permissionResolvedExpressions);
                    Element permissionCacheEntry = unresolvedPermAndValuesToResolvedPerm.get((Serializable)key);
                    if (permissionCacheEntry != null) {
                        PermissionCollection permissionsFromCache = (PermissionCollection)permissionCacheEntry.getValue();
                        logger.finest("get resolved permission from cache");
                        Enumeration<Permission> enumeration = permissionsFromCache.elements();
                        while (enumeration.hasMoreElements()) {
                            Permission permissionFromCache = enumeration.nextElement();
                            ((PermissionCollection)resolvedPermissions).add(permissionFromCache);
                        }
                        return resolvedPermissions;
                    }
                }
                catch (CacheException e) {
                    logger.log(Level.WARNING, "Failed using caches : " + e.getMessage());
                }
            }
        }
        ArrayList<Permission> unresolvedPermissions = new ArrayList<Permission>();
        unresolvedPermissions.add(permission);
        HashMap resolvedExpressionsByPermission = new HashMap();
        while (!unresolvedPermissions.isEmpty()) {
            boolean matchesInActions;
            String[] actionsArray;
            String action;
            Set partiallyResolvedActions;
            boolean matchesInName;
            Permission unresolvedPermission = (Permission)unresolvedPermissions.remove(0);
            String name = unresolvedPermission.getName();
            Set partiallyResolvedNames = PermissionUtils.resolvePartiallyExpression(name, JEXL_PATTERN, jexlContext, resolvedExpressionsByPermission, subjectResolvedExpressions);
            if (partiallyResolvedNames == null) {
                return new JGPositivePermissionCollection();
            }
            boolean bl = matchesInName = partiallyResolvedNames.size() != 1 || !partiallyResolvedNames.contains(name);
            if (matchesInName) {
                Iterator itNames = partiallyResolvedNames.iterator();
                while (itNames.hasNext()) {
                    Permission partiallyResolvedPermission;
                    String resolvedName = (String)itNames.next();
                    try {
                        partiallyResolvedPermission = PermissionUtils.getPermission(permission.getClass().getName(), resolvedName, unresolvedPermission.getActions());
                    }
                    catch (ClassNotFoundException e) {
                        logger.warning(e.getMessage());
                        continue;
                    }
                    unresolvedPermissions.add(partiallyResolvedPermission);
                }
                continue;
            }
            String actions = unresolvedPermission.getActions();
            if (actions == null) {
                actions = "";
            }
            if ((partiallyResolvedActions = PermissionUtils.resolvePartiallyExpression(action = (actionsArray = actions.split(","))[0], JEXL_PATTERN, jexlContext, resolvedExpressionsByPermission, subjectResolvedExpressions)) == null) {
                return new JGPositivePermissionCollection();
            }
            boolean bl2 = matchesInActions = partiallyResolvedActions.size() != 1 || !partiallyResolvedActions.contains(action);
            if (matchesInActions) {
                Iterator itActions = partiallyResolvedActions.iterator();
                while (itActions.hasNext()) {
                    Permission partiallyResolvedPermission;
                    String resolvedAction = (String)itActions.next();
                    try {
                        partiallyResolvedPermission = PermissionUtils.getPermission(permission.getClass().getName(), unresolvedPermission.getName(), resolvedAction);
                    }
                    catch (ClassNotFoundException e) {
                        logger.warning(e.getMessage());
                        continue;
                    }
                    unresolvedPermissions.add(partiallyResolvedPermission);
                }
                continue;
            }
            ((PermissionCollection)resolvedPermissions).add(unresolvedPermission);
        }
        if (cachesEnabled) {
            try {
                List unresolvedKeys = unresolvedPermToNeededExpressions.getKeys();
                if (!unresolvedKeys.contains(permission)) {
                    HashSet permissionNeededExpressions = new HashSet(resolvedExpressionsByPermission.keySet());
                    unresolvedPermToNeededExpressions.put(new Element((Serializable)permission, permissionNeededExpressions));
                }
            }
            catch (CacheException e) {
                logger.log(Level.WARNING, "Failed using caches : " + e.getMessage());
            }
            Element cacheEntry = new Element((Serializable)PermissionUtils.createKey(permission, resolvedExpressionsByPermission), (Serializable)resolvedPermissions);
            unresolvedPermAndValuesToResolvedPerm.put(cacheEntry);
            logger.finest("add resolved permissions to cache");
        }
        return resolvedPermissions;
    }

    private static Set resolvePartiallyExpression(String expression, Pattern pattern, JexlContext jexlContext, Map resolvedExpressionsByPermission, Map subjectResolvedExpressions) {
        boolean hasMatches = false;
        boolean hasNull = false;
        HashSet<String> resolvedExpressionsSet = new HashSet<String>();
        Matcher matcher = pattern.matcher(expression);
        if (matcher.find()) {
            hasMatches = true;
            String matchedExpression = matcher.group();
            String jexlExpression = matchedExpression.substring(2, matchedExpression.length() - 1);
            Object resolvedExpression = null;
            if (subjectResolvedExpressions.containsKey(jexlExpression)) {
                resolvedExpression = (Set)subjectResolvedExpressions.get(jexlExpression);
            } else {
                try {
                    Expression expr = ExpressionFactory.createExpression((String)jexlExpression);
                    resolvedExpression = expr.evaluate(jexlContext);
                    subjectResolvedExpressions.put(jexlExpression, resolvedExpression);
                }
                catch (Exception e) {
                    logger.warning("Failed to resolve expression : " + jexlExpression);
                }
            }
            if (!resolvedExpressionsByPermission.containsKey(jexlExpression)) {
                resolvedExpressionsByPermission.put(jexlExpression, resolvedExpression);
            }
            if (resolvedExpression == null) {
                hasNull = true;
            } else if (resolvedExpression instanceof Set) {
                Iterator it = ((Set)resolvedExpression).iterator();
                while (it.hasNext()) {
                    StringBuffer builder = new StringBuffer(expression);
                    builder.replace(matcher.start(), matcher.end(), (String)it.next());
                    resolvedExpressionsSet.add(builder.toString());
                }
            } else if (resolvedExpression instanceof String) {
                StringBuffer builder = new StringBuffer(expression);
                builder.replace(matcher.start(), matcher.end(), (String)resolvedExpression);
                resolvedExpressionsSet.add(builder.toString());
            }
        }
        if (!hasMatches) {
            resolvedExpressionsSet.add(expression);
        }
        if (hasNull) {
            return null;
        }
        return resolvedExpressionsSet;
    }

    public static void createCaches() throws CacheException {
        if (unresolvedPermToNeededExpressions == null || unresolvedPermAndValuesToResolvedPerm == null) {
            logger.info("Creating caches for permissions evaluations");
            manager = CacheManager.create();
            unresolvedPermToNeededExpressions = manager.getCache("unresolvedPermToNeededExpressions");
            unresolvedPermAndValuesToResolvedPerm = manager.getCache("unresolvedPermAndValuesToResolvedPerm");
            if (unresolvedPermToNeededExpressions == null || unresolvedPermAndValuesToResolvedPerm == null) {
                logger.warning("Failed to create caches for permissions evaluations, use non-caching evaluation");
                PermissionUtils.setCachesEnabled(false);
            }
        }
    }

    public static boolean isCachesEnabled() {
        return cachesEnabled;
    }

    public static void setCachesEnabled(boolean cachesEnabled) {
        PermissionUtils.cachesEnabled = cachesEnabled;
    }

    public static Permissions mergePermissionCollections(PermissionCollection perm1, PermissionCollection perm2) {
        Permissions result = new Permissions();
        Enumeration<Permission> enumPerm1 = perm1.elements();
        while (enumPerm1.hasMoreElements()) {
            Permission perm = enumPerm1.nextElement();
            result.add(perm);
        }
        Enumeration<Permission> enumPerm2 = perm2.elements();
        while (enumPerm2.hasMoreElements()) {
            Permission perm = enumPerm2.nextElement();
            result.add(perm);
        }
        return result;
    }

    static {
        JEXL_PATTERN = Pattern.compile("(\\$\\{[^\\}]+\\})");
    }
}

