/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.permissions;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.jguard.core.authorization.permissions.NoSuchPermissionException;

public abstract class JGPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3834030277143377201L;
    private static final Logger logger = Logger.getLogger(JGPermissionCollection.class.getName());
    protected Set permissions;

    public JGPermissionCollection() {
        this.permissions = new HashSet();
    }

    public JGPermissionCollection(Collection coll) {
        this.permissions = new HashSet(coll);
    }

    public void add(Permission permission) {
        if (permission != null) {
            this.permissions.add(permission);
        }
    }

    public void addAll(Set permissionSet) {
        if (permissionSet != null) {
            this.permissions.addAll(permissionSet);
        }
    }

    public void addAll(PermissionCollection pcColl) {
        Enumeration<Permission> en = pcColl.elements();
        while (en.hasMoreElements()) {
            this.permissions.add(en.nextElement());
        }
    }

    public Enumeration elements() {
        return Collections.enumeration(this.permissions);
    }

    public Permission getPermission(String permissionName) throws NoSuchPermissionException {
        Iterator it = this.permissions.iterator();
        while (it.hasNext()) {
            Permission permission = (Permission)it.next();
            if (!permission.getName().equals(permissionName)) continue;
            return permission;
        }
        logger.warning("permission " + permissionName + " not found in JGPermissionCollection#getPermission!!!");
        logger.warning("permissions=" + this.permissions);
        throw new NoSuchPermissionException("permission " + permissionName + " not found in JGPermissionCollection#getPermission");
    }

    public void removePermission(Permission permission) {
        if (permission != null) {
            this.permissions.remove(permission);
        }
    }

    public void removePermissions(PermissionCollection permColl) {
        Enumeration<Permission> permissionsEnum = permColl.elements();
        while (permissionsEnum.hasMoreElements()) {
            this.permissions.remove(permissionsEnum.nextElement());
        }
    }

    public void clear() {
        this.permissions.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator permissionsIterator = this.permissions.iterator();
        while (permissionsIterator.hasNext()) {
            Permission permission = (Permission)permissionsIterator.next();
            sb.append(permission.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public int size() {
        return this.permissions.size();
    }

    public Set getPermissions() {
        return this.permissions;
    }

    public boolean containsPermission(Permission permission) {
        return this.permissions.contains(permission);
    }

    public void setPermissions(Set perms) {
        this.permissions = perms;
    }
}

