/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.permissions;

import java.security.Permission;
import java.util.Date;

public class DurationDecorator
extends Permission {
    private static final long serialVersionUID = 3085444057980849140L;
    private Permission permission;
    private Date begin;
    private Date end;

    public DurationDecorator(Permission p, Date start, Date end) {
        super(p.getName());
        this.permission = p;
        this.begin = start;
        this.end = end;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DurationDecorator) {
            DurationDecorator duration = (DurationDecorator)obj;
            if (this.permission.getName().equals(duration.getName()) && this.permission.getActions().equals(duration.getActions())) {
                return true;
            }
        }
        return false;
    }

    public String getActions() {
        return this.permission.getActions();
    }

    public int hashCode() {
        int hashCode = this.permission.hashCode();
        if (this.begin != null) {
            hashCode += this.begin.hashCode();
        }
        if (this.end != null) {
            hashCode += this.end.hashCode();
        }
        return hashCode;
    }

    public boolean implies(Permission permission) {
        Date now = new Date();
        if (this.begin != null && now.before(this.begin)) {
            return false;
        }
        if (this.end != null && now.after(this.end)) {
            return false;
        }
        return this.permission.implies(permission);
    }
}

