/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization.permissions;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.jguard.core.authorization.permissions.JGPermissionCollection;
import net.sf.jguard.core.authorization.permissions.PermissionUtils;

public class Domain
extends JGPermissionCollection
implements Comparable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 178066544850786962L;
    private String name;

    public Domain(String domainName) {
        this.name = domainName;
    }

    public Domain(String domainName, PermissionCollection pcoll) {
        this.name = domainName;
        this.permissions = new HashSet();
        super.addAll(pcoll);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String domainName) {
        this.name = domainName;
    }

    public boolean equals(Object obj) {
        Domain domain = (Domain)obj;
        return this.name.equals(domain.getName());
    }

    public int hashCode() {
        return this.name.toString().hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        Domain dom = new Domain(new String(this.name));
        HashSet<Permission> perms = new HashSet<Permission>();
        Iterator itPermissions = this.permissions.iterator();
        while (itPermissions.hasNext()) {
            Permission newPerm;
            Permission perm = (Permission)itPermissions.next();
            String permName = perm.getName();
            String permActions = perm.getActions();
            Class<?> permClass = perm.getClass();
            try {
                newPerm = PermissionUtils.getPermission(permClass.getName(), permName, permActions);
            }
            catch (ClassNotFoundException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
            perms.add(newPerm);
        }
        dom.setPermissions(perms);
        return dom;
    }

    public int compareTo(Object o) {
        Domain domain = (Domain)o;
        return this.name.compareTo(domain.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append(" name=" + this.name);
        sb.append("\n");
        sb.append(" permissions=\n" + super.toString());
        sb.append("\n");
        return sb.toString();
    }

    public boolean implies(Permission permission) {
        Iterator it = this.permissions.iterator();
        while (it.hasNext()) {
            Permission p = (Permission)it.next();
            if (!p.implies(permission)) continue;
            return true;
        }
        return false;
    }
}

