/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authorization;

import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.Policy;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authorization.AuthorizationBindings;
import net.sf.jguard.core.authorization.policy.AccessControllerUtils;
import net.sf.jguard.core.authorization.policy.JGuardPolicy;

public class PolicyDecisionPoint {
    private static final Logger logger = Logger.getLogger(PolicyDecisionPoint.class.getName());
    private AuthorizationBindings authorizationBindings = null;

    public PolicyDecisionPoint(AuthorizationBindings phases) {
        this.authorizationBindings = phases;
    }

    public void process(AccessContext context) {
        Permission permission = this.authorizationBindings.getPermissionRequested(context);
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (!AccessControllerUtils.hasPermission(subject, permission)) {
            this.authorizationBindings.setLastAccessDeniedPermission(context, permission);
            logger.finest(" accessdenied phase ");
            this.authorizationBindings.accessDenied(context);
        } else {
            logger.finest(" authorize access to resource protected by permission " + permission.getClass().getName() + " name=" + permission.getName() + " actions=" + permission.getActions());
            this.authorizationBindings.authorize(context);
        }
    }

    public void addAlwaysGrantedPermissionsToPolicy(Permissions alwaysGrantedPermissions) {
        Policy policy;
        if (alwaysGrantedPermissions == null) {
            return;
        }
        if (!JGuardPolicy.class.isAssignableFrom((policy = AccessControllerUtils.getPolicy()).getClass())) {
            throw new UnsupportedOperationException(" the current java.security.Policy subclass is not a subclass of net.sf.jguard.core.authorization.policy.JGuardPolicy ");
        }
        JGuardPolicy jgPolicy = (JGuardPolicy)policy;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        jgPolicy.addAlwaysGrantedPermissions(cl, alwaysGrantedPermissions);
    }

    public AuthorizationBindings getAuthorizationBindings() {
        return this.authorizationBindings;
    }
}

