/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authentication.manager;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jguard.core.authentication.AuthenticationException;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;

public class AuthenticationManagerFactory {
    private static AuthenticationManager authenticationManager;
    private static Logger logger;

    public static AuthenticationManager getAuthenticationManager() {
        return authenticationManager;
    }

    public static AuthenticationManager createAuthenticationManager(Class authenticationManagerImpl, Map map) throws AuthenticationException {
        AuthenticationManager authenticationManager;
        logger.info("authenticationManagerImpl=" + authenticationManagerImpl.getName());
        if (authenticationManagerImpl == null) {
            throw new AuthenticationException(" authenticationManager implementation is null or empty " + authenticationManagerImpl);
        }
        try {
            Constructor constructor = authenticationManagerImpl.getConstructor(Map.class);
            authenticationManager = (AuthenticationManager)constructor.newInstance(map);
        }
        catch (InvocationTargetException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new AuthenticationException(" InstantiationException " + ex.getMessage(), ex);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AuthenticationException(" InstantiationException " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AuthenticationException(" IllegalAccessException " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AuthenticationException(" SecurityException " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AuthenticationException(" NoSuchMethodException " + e.getMessage(), e);
        }
        return authenticationManager;
    }

    public static void setAuthenticationManager(AuthenticationManager authenticationManager) {
        AuthenticationManagerFactory.authenticationManager = authenticationManager;
    }

    static {
        logger = Logger.getLogger(AuthenticationManagerFactory.class.getName());
    }
}

