/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authentication.credentials;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JGuardCredential
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2251806339749583892L;
    private Logger logger = Logger.getLogger(JGuardCredential.class.getName());
    private String name = null;
    private Object value = null;
    private Long id;
    private boolean publicVisibility;

    public JGuardCredential() {
    }

    public JGuardCredential(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String id) {
        this.name = id;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        JGuardCredential cred = null;
        if (!(obj instanceof JGuardCredential)) {
            return false;
        }
        cred = (JGuardCredential)obj;
        return this.name.equals(cred.name) && this.value.equals(cred.value);
    }

    public int hashCode() {
        if (this.name != null && this.value != null) {
            return this.name.hashCode() + this.value.hashCode();
        }
        if (this.value == null) {
            return this.name.hashCode();
        }
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("id=");
        sb.append(this.name);
        sb.append("\n");
        sb.append("value=");
        sb.append(this.value);
        sb.append("\n");
        sb.append("identity=");
        sb.append("\n");
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        JGuardCredential clone = new JGuardCredential();
        clone.setName(this.name);
        if (this.value == null) {
            clone.setValue(null);
            return clone;
        }
        if (this.value instanceof Cloneable) {
            Class[] clazz = new Class[]{null};
            try {
                Method cloneMethod = this.value.getClass().getMethod("clone", clazz);
                Object clonedValue = cloneMethod.invoke(this.value, null);
                clone.setValue(clonedValue);
            }
            catch (SecurityException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                throw new CloneNotSupportedException(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                throw new CloneNotSupportedException(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                throw new CloneNotSupportedException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                throw new CloneNotSupportedException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
                throw new CloneNotSupportedException(e.getMessage());
            }
        } else if (this.value instanceof String) {
            clone.setValue(this.value);
        } else {
            throw new CloneNotSupportedException(this.value.getClass() + " does not support cloning mechanism ");
        }
        return clone;
    }

    public static Set cloneCredentialsSet(Set credentials) throws CloneNotSupportedException {
        HashSet<Object> clonedCredentials = new HashSet<Object>();
        Iterator itCredentials = credentials.iterator();
        while (itCredentials.hasNext()) {
            JGuardCredential credential = (JGuardCredential)itCredentials.next();
            clonedCredentials.add(credential.clone());
        }
        return clonedCredentials;
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public boolean isPublicVisibility() {
        return this.publicVisibility;
    }

    public void setPublicVisibility(boolean publicVisibility) {
        this.publicVisibility = publicVisibility;
    }
}

