/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authentication.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class LocalLoginContext {
    private static final Logger logger = Logger.getLogger(LocalLoginContext.class.getName());
    private static final String OTHER = "other";
    private List appEntriesList = null;
    private CallbackHandler cbHandler = null;
    private Subject subject = null;
    private Map flags = null;
    private boolean loginSucceed = true;
    private boolean subjectNotProvided;
    private List loginModules = null;

    public LocalLoginContext(String name, CallbackHandler cbHandler) throws LoginException {
        this.appEntriesList = this.getAppConfigurationEntry(Configuration.getConfiguration(), name);
        this.cbHandler = cbHandler;
        this.subject = new Subject();
        this.flags = new HashMap();
        this.subjectNotProvided = true;
    }

    public LocalLoginContext(String name, CallbackHandler cbHandler, Configuration configuration) throws LoginException {
        this.appEntriesList = this.getAppConfigurationEntry(configuration, name);
        this.cbHandler = cbHandler;
        this.subject = new Subject();
        this.flags = new HashMap();
        this.subjectNotProvided = true;
    }

    public LocalLoginContext(String name, Subject subject, CallbackHandler cbHandler) throws LoginException {
        this.appEntriesList = this.getAppConfigurationEntry(Configuration.getConfiguration(), name);
        this.cbHandler = cbHandler;
        this.subject = subject;
        this.flags = new HashMap();
    }

    public LocalLoginContext(String name, Subject subject, CallbackHandler cbHandler, Configuration configuration) throws LoginException {
        this.appEntriesList = this.getAppConfigurationEntry(configuration, name);
        this.cbHandler = cbHandler;
        this.subject = subject;
        this.flags = new HashMap();
    }

    private List getAppConfigurationEntry(Configuration config, String name) {
        AppConfigurationEntry[] appEntries = null;
        appEntries = config.getAppConfigurationEntry(name);
        if (appEntries == null) {
            appEntries = config.getAppConfigurationEntry(OTHER);
        }
        return Arrays.asList(appEntries);
    }

    public void login() throws LoginException {
        this.loginModules = this.initializeLoginModules(this.appEntriesList, this.subject, this.cbHandler);
        Iterator itLoginModules = this.loginModules.iterator();
        LoginException exception = null;
        while (itLoginModules.hasNext()) {
            LoginModule module = (LoginModule)itLoginModules.next();
            AppConfigurationEntry.LoginModuleControlFlag flag = (AppConfigurationEntry.LoginModuleControlFlag)this.flags.get(module);
            if (!(AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.equals(flag) || AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.equals(flag) || AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.equals(flag) || AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.equals(flag))) {
                logger.severe(" loginModule=" + module.getClass() + " has got an invalid flag=" + flag);
                logger.severe(" this loginModule is skipped in the authentication process ");
                continue;
            }
            try {
                boolean loginModuleSucceed = module.login();
                if (!loginModuleSucceed) {
                    logger.finest(" loginModule " + module.getClass() + " in 'login' phase is ignored  ");
                    continue;
                }
                logger.finest(" loginModule " + module.getClass() + " in 'login' phase succeed ");
                if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.equals(flag) || AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.equals(flag)) continue;
                if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.equals(flag)) break;
                if (!AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.equals(flag)) continue;
            }
            catch (LoginException e) {
                if (exception == null) {
                    exception = e;
                }
                logger.finest(" loginModule " + module.getClass() + " in 'login' phase failed ");
                logger.info(" authentication fails " + e.getMessage());
                if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.equals(flag)) {
                    this.loginSucceed = false;
                    continue;
                }
                if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.equals(flag)) {
                    this.loginSucceed = false;
                    break;
                }
                if (!AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.equals(flag) && !AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL.equals(flag)) continue;
            }
        }
        Iterator itLoginModules2 = this.loginModules.iterator();
        if (this.loginSucceed) {
            while (itLoginModules2.hasNext()) {
                LoginModule module = (LoginModule)itLoginModules2.next();
                try {
                    boolean moduleCommitSucceed = module.commit();
                    if (moduleCommitSucceed) {
                        logger.finest(" loginModule " + module.getClass() + " in 'commit' phase succeeed");
                        continue;
                    }
                    logger.finest(" loginModule " + module.getClass() + " in 'commit' phase is ignored ");
                }
                catch (LoginException e) {
                    logger.finest(" loginModule " + module.getClass() + " in 'commit' phase failed  ");
                    this.abort(this.loginModules, e);
                    throw e;
                }
            }
        } else {
            this.abort(this.loginModules, exception);
        }
    }

    private void abort(List loginModules, LoginException exception) throws LoginException {
        Iterator itLoginModules = loginModules.iterator();
        while (itLoginModules.hasNext()) {
            LoginModule module = (LoginModule)itLoginModules.next();
            try {
                boolean moduleAbortSucceed = module.abort();
                if (moduleAbortSucceed) {
                    logger.finest(" loginModule " + module.getClass() + " in 'abort' phase succeeed");
                    continue;
                }
                logger.finest(" loginModule " + module.getClass() + " in 'abort' phase is ignored ");
            }
            catch (LoginException e) {
                logger.finest(" loginModule " + module.getClass() + " in 'abort' phase failed ");
                logger.warning(e.getMessage());
                throw exception;
            }
        }
        throw exception;
    }

    private List initializeLoginModules(List appConfigurationEntries, Subject subject, CallbackHandler cbHandler) {
        HashMap sharedState = new HashMap();
        ArrayList<LoginModule> loginModules = new ArrayList<LoginModule>();
        Iterator itAppEntries = appConfigurationEntries.iterator();
        while (itAppEntries.hasNext()) {
            AppConfigurationEntry entry = (AppConfigurationEntry)itAppEntries.next();
            AppConfigurationEntry.LoginModuleControlFlag flag = entry.getControlFlag();
            String loginModuleName = entry.getLoginModuleName();
            Map<String, ?> options = entry.getOptions();
            Class<?> loginModuleClass = null;
            LoginModule module = null;
            try {
                loginModuleClass = Thread.currentThread().getContextClassLoader().loadClass(loginModuleName);
            }
            catch (ClassNotFoundException e) {
                logger.severe(" loginModule Class " + loginModuleName + " not found ");
                throw new RuntimeException("loginModule " + loginModuleName + " is not found " + e.getMessage());
            }
            try {
                module = (LoginModule)loginModuleClass.newInstance();
            }
            catch (InstantiationException e) {
                logger.severe(" loginModule Class " + loginModuleName + " cannot be instantiated  ");
                throw new RuntimeException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.severe(" loginModule Class " + loginModuleName + " cannot be accessed  ");
                throw new RuntimeException(e.getMessage());
            }
            module.initialize(subject, cbHandler, sharedState, options);
            this.flags.put(module, flag);
            loginModules.add(module);
        }
        return loginModules;
    }

    public void logout() throws LoginException {
        LoginException exception = null;
        if (this.loginModules == null) {
            return;
        }
        Iterator itLoginModules = this.loginModules.iterator();
        while (itLoginModules.hasNext()) {
            LoginModule module = (LoginModule)itLoginModules.next();
            try {
                boolean moduleLogoutSucceed = module.logout();
                if (moduleLogoutSucceed) {
                    logger.finest(" loginModule " + module.getClass() + " in 'logout' phase succeeed");
                    continue;
                }
                logger.finest(" loginModule " + module.getClass() + " in 'logout' phase is ignored ");
            }
            catch (LoginException e) {
                logger.finest(" loginModule " + module.getClass() + " in 'logout' phase failed ");
                logger.severe(e.getMessage());
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public Subject getSubject() {
        if (!this.loginSucceed && this.subjectNotProvided) {
            return null;
        }
        return this.subject;
    }
}

