/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authentication.configuration;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public final class JGuardConfiguration
extends Configuration {
    private Collection internalConfigs = null;
    private Map appConfigurations = null;
    private static Logger logger = Logger.getLogger(JGuardConfiguration.class.getName());

    public JGuardConfiguration() {
        logger.finest("#####  JGuardConfiguration  #####");
        this.internalConfigs = new ArrayList();
        this.appConfigurations = new HashMap();
    }

    public void refresh() {
        AccessController.checkPermission(new AuthPermission("refreshLoginConfiguration"));
        if (this.internalConfigs.size() > 0) {
            Iterator itConfigs = this.internalConfigs.iterator();
            while (itConfigs.hasNext()) {
                Configuration tempConfig = (Configuration)itConfigs.next();
                tempConfig.refresh();
            }
        }
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
        ArrayList<AppConfigurationEntry> appInternalEntries = new ArrayList<AppConfigurationEntry>();
        Iterator itConfigs = this.internalConfigs.iterator();
        while (itConfigs.hasNext()) {
            Configuration tempConfig = (Configuration)itConfigs.next();
            if (tempConfig == null) {
                itConfigs.remove();
                logger.log(Level.WARNING, "the default Configuration implementation has been removed from the JGuardConfiguration which imported it");
                continue;
            }
            if (tempConfig.getAppConfigurationEntry(applicationName) == null) continue;
            appInternalEntries.addAll(Arrays.asList(tempConfig.getAppConfigurationEntry(applicationName)));
        }
        List jGuardAppConfigEntries = (List)this.appConfigurations.get(applicationName);
        if (jGuardAppConfigEntries != null) {
            appInternalEntries.addAll(jGuardAppConfigEntries);
        }
        if (appInternalEntries.size() > 0) {
            return appInternalEntries.toArray(new AppConfigurationEntry[appInternalEntries.size()]);
        }
        return null;
    }

    public void addConfigEntriesForApplication(String applicationName, List entries) {
        if (entries == null || entries.size() == 0) {
            logger.log(Level.WARNING, " entries provided are null or empty ");
            return;
        }
        List applicationEntries = (List)this.appConfigurations.get(applicationName);
        if (applicationEntries == null) {
            this.appConfigurations.put(applicationName, entries);
        }
    }

    public void addConfigEntriesLikeApplication(String applicationName, String applicationTemplateName) {
        List applicationEntries = (List)this.appConfigurations.get(applicationTemplateName);
        if (applicationEntries == null) {
            logger.log(Level.SEVERE, " there is no applications registered with your applicationName and password ");
            return;
        }
        this.appConfigurations.put(applicationName, applicationEntries);
    }

    public void addConfigEntriesLikeApplication(String applicationName, String password, String applicationTemplateName) {
        StringBuffer newApplicationName = new StringBuffer(applicationName).append('#').append(password);
        this.addConfigEntriesLikeApplication(newApplicationName.toString(), applicationTemplateName);
    }

    protected void includeConfiguration(Configuration configuration) {
        if (!configuration.getClass().getName().equals(JGuardConfiguration.class.getName()) && !this.internalConfigs.contains(configuration)) {
            this.internalConfigs.add(configuration);
        }
    }

    public void addConfigEntriesForApplication(String applicationName, String password, List entries) {
        StringBuffer newApplicationName = new StringBuffer(applicationName).append('#').append(password);
        this.addConfigEntriesForApplication(newApplicationName.toString(), entries);
    }
}

