/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authentication.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import net.sf.jguard.core.authentication.configuration.JGuardConfiguration;

public class ConfigurationHelper {
    private static String scope;
    private static boolean configurationInstalled;
    private static Logger logger;
    private static final String COM_SUN_SECURITY_AUTH_LOGIN_CONFIG_FILE = "com.sun.security.auth.login.ConfigFile";

    public static void addConfigurationEntryForWebapp(JGuardConfiguration configuration, String applicationName, Map authenticationSettings, boolean debug) {
        List webappEntries = ConfigurationHelper.buildAppConfigurationEntries(applicationName, authenticationSettings, debug);
        configuration.addConfigEntriesForApplication(applicationName, webappEntries);
    }

    public static void installConfiguration(boolean includeOldConfiguration, boolean includeConfigFromJavaParam) throws RuntimeException {
        if (!configurationInstalled) {
            includeConfigFromJavaParam = false;
        }
        JGuardConfiguration jGuardConf = ConfigurationHelper.installWithOldConfig(includeOldConfiguration);
        if (includeConfigFromJavaParam) {
            try {
                Class<?> defaultConfigClass = Class.forName(COM_SUN_SECURITY_AUTH_LOGIN_CONFIG_FILE);
                Configuration defaultConfiguration = (Configuration)defaultConfigClass.newInstance();
                jGuardConf.includeConfiguration(defaultConfiguration);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.SEVERE, "com.sun.security.auth.login.ConfigFile class cannot be found " + e.getMessage(), e);
            }
            catch (InstantiationException e) {
                logger.log(Level.SEVERE, "com.sun.security.auth.login.ConfigFile class cannot be instantiated " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, "com.sun.security.auth.login.ConfigFile class cannot be accessed " + e.getMessage(), e);
            }
        }
    }

    private static JGuardConfiguration installWithOldConfig(boolean includeOldConfiguration) throws RuntimeException {
        JGuardConfiguration jGuardConf;
        Configuration oldConfiguration = null;
        boolean skipOldConfig = false;
        try {
            oldConfiguration = Configuration.getConfiguration();
            logger.log(Level.FINE, " oldConfiguration=" + oldConfiguration.getClass().getName());
            logger.log(Level.FINE, " oldConfiguration=" + oldConfiguration);
        }
        catch (SecurityException sex) {
            skipOldConfig = true;
            logger.log(Level.FINE, " addConfigurationEntryForWebapp() -  exception raised when we try to retrieve the default Configuration instance ");
            logger.log(Level.FINE, " addConfigurationEntryForWebapp() - " + sex.getMessage());
            logger.log(Level.FINE, " jGuard will not include the old Configuration ");
        }
        catch (NullPointerException npe) {
            skipOldConfig = true;
            logger.log(Level.FINE, "addConfigurationEntryForWebapp() - a NullPointerException has been raised when the default configuration :no configuration is defined ");
            logger.log(Level.FINE, "addConfigurationEntryForWebapp() - " + npe.getMessage());
        }
        if (oldConfiguration == null || !oldConfiguration.getClass().getName().equals(JGuardConfiguration.class.getName())) {
            jGuardConf = new JGuardConfiguration();
            Configuration.setConfiguration(jGuardConf);
            logger.log(Level.INFO, " JGuardConfiguration is set ");
        } else {
            if (!oldConfiguration.getClass().equals(JGuardConfiguration.class) && oldConfiguration.getClass().getName().equals(JGuardConfiguration.class.getName())) {
                logger.log(Level.SEVERE, " jGuard_jvm must be placed under the shared libraries directory or on the jvm side, not in the WEB-INF/lib directory of the webapp ");
                throw new RuntimeException(" jGuard_jvm must be placed under the shared libraries directory or on the jvm side, not in the WEB-INF/lib directory of the webapp ");
            }
            jGuardConf = (JGuardConfiguration)Configuration.getConfiguration();
            logger.log(Level.FINE, "configuration=" + oldConfiguration.getClass().getName());
            logger.log(Level.FINE, " JGuardConfiguration is already set ");
            skipOldConfig = true;
        }
        if (!skipOldConfig && includeOldConfiguration) {
            logger.log(Level.INFO, " jGuard include the old Configuration ");
            jGuardConf.includeConfiguration(oldConfiguration);
        }
        configurationInstalled = true;
        return jGuardConf;
    }

    /*
     * WARNING - void declaration
     */
    private static List buildAppConfigurationEntries(String applicationName, Map authSettings, boolean debug) {
        ArrayList<AppConfigurationEntry> appConfigurationEntryList = new ArrayList<AppConfigurationEntry>();
        List loginModules = (List)authSettings.get("loginModules");
        if (loginModules == null) {
            throw new IllegalArgumentException(" no loginModules have been configured for the application=" + applicationName);
        }
        Iterator itLoginModules = loginModules.iterator();
        while (itLoginModules.hasNext()) {
            void var9_9;
            AppConfigurationEntry.LoginModuleControlFlag controlFlag;
            Map loginModuleMap = (Map)itLoginModules.next();
            String loginModuleClassName = (String)loginModuleMap.get("name");
            String loginModuleFlag = (String)loginModuleMap.get("flag");
            if (loginModuleFlag.equalsIgnoreCase("REQUIRED")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (loginModuleFlag.equalsIgnoreCase("OPTIONAL")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else if (loginModuleFlag.equalsIgnoreCase("REQUISITE")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (loginModuleFlag.equalsIgnoreCase("SUFFICIENT")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else {
                throw new IllegalArgumentException(" invalid loginModuleControlFlag =" + loginModuleFlag + " is neither OPTIONAL,REQUIRED,REQUISITE nor SUFFICIENT ");
            }
            Map loginModuleOptions = (Map)loginModuleMap.get("loginModuleOptions");
            loginModuleOptions.put("applicationName", applicationName);
            AppConfigurationEntry entry = new AppConfigurationEntry(loginModuleClassName, (AppConfigurationEntry.LoginModuleControlFlag)var9_9, loginModuleOptions);
            appConfigurationEntryList.add(entry);
        }
        if (appConfigurationEntryList.size() == 0) {
            throw new IllegalArgumentException(" no loginModules have been configured for the application=" + applicationName);
        }
        return appConfigurationEntryList;
    }

    public static String getScope() {
        return scope;
    }

    static {
        configurationInstalled = false;
        logger = Logger.getLogger(ConfigurationHelper.class.getName());
    }
}

