/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authentication;

import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.sf.jguard.core.authentication.AuthenticationException;
import net.sf.jguard.core.authentication.callbacks.InetAddressCallback;
import net.sf.jguard.core.authentication.configuration.LocalLoginContext;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.authentication.manager.AuthenticationManagerFactory;
import net.sf.jguard.core.principals.UserPrincipal;
import net.sf.jguard.core.util.ThrowableUtils;

public class AuthenticationUtils {
    private LoginContext loginContext = null;
    private LocalLoginContext localLoginContext = null;
    private Subject subject = null;
    private boolean loggedOut = false;
    private boolean local = false;
    private static final Logger logger = Logger.getLogger(AuthenticationUtils.class.getName());
    private Configuration configuration = null;

    public AuthenticationUtils() {
    }

    public AuthenticationUtils(Configuration config) {
        this.configuration = config;
        this.local = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void login(String applicationName, CallbackHandler cbh) throws LoginException {
        InetAddressCallback inetCbk = new InetAddressCallback();
        NameCallback nameCallback = new NameCallback(" ");
        boolean authenticationSucceed = false;
        Locale locale = Locale.getDefault();
        LanguageCallback languageCallback = new LanguageCallback();
        try {
            Callback[] callbacks = new Callback[]{inetCbk, nameCallback, languageCallback};
            try {
                cbh.handle(callbacks);
                locale = languageCallback.getLocale();
            }
            catch (UnsupportedCallbackException ex) {
                throw new LoginException(ex.getMessage());
            }
            catch (IOException ex) {
                throw new LoginException(ex.getMessage());
            }
            if (this.local) {
                this.localLoginContext = new LocalLoginContext(applicationName, cbh, this.configuration);
            } else {
                this.loginContext = new LoginContext(applicationName, cbh);
            }
        }
        catch (LoginException se) {
            logger.log(Level.SEVERE, "LoginContext cannot be created. " + se.getMessage(), se);
            throw se;
        }
        try {
            try {
                if (this.local) {
                    this.localLoginContext.login();
                } else {
                    this.loginContext.login();
                }
                authenticationSucceed = true;
            }
            catch (LoginException le) {
                authenticationSucceed = false;
                Throwable localizedThrowable = ThrowableUtils.localizeThrowable(le, locale);
                throw (LoginException)localizedThrowable;
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            AuthenticationManager authNManager = AuthenticationManagerFactory.getAuthenticationManager();
            try {
                long now = System.currentTimeMillis();
                authNManager.persistUserAccessAttempt(nameCallback.getName(), inetCbk.getHostAdress(), inetCbk.getHostName(), authenticationSucceed, now);
                logger.info("user from Host adress=" + inetCbk.getHostAdress() + " bound to host name=" + inetCbk.getHostName() + " has tried to authenticate. boolean result =" + authenticationSucceed + " timeStamp=" + now + " locale=" + locale.getDisplayName());
                throw throwable;
            }
            catch (AuthenticationException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                throw new LoginException(ex.getMessage());
            }
        }
        AuthenticationManager authNManager = AuthenticationManagerFactory.getAuthenticationManager();
        try {}
        catch (AuthenticationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new LoginException(ex.getMessage());
        }
        long now = System.currentTimeMillis();
        authNManager.persistUserAccessAttempt(nameCallback.getName(), inetCbk.getHostAdress(), inetCbk.getHostName(), authenticationSucceed, now);
        logger.info("user from Host adress=" + inetCbk.getHostAdress() + " bound to host name=" + inetCbk.getHostName() + " has tried to authenticate. boolean result =" + authenticationSucceed + " timeStamp=" + now + " locale=" + locale.getDisplayName());
        this.subject = this.local ? this.localLoginContext.getSubject() : this.loginContext.getSubject();
        if (this.subject == null) return;
        UserPrincipal userPrincipal = new UserPrincipal(this.subject);
        this.subject.getPrincipals().add(userPrincipal);
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void logout() {
        if (!this.loggedOut) {
            try {
                if (this.local) {
                    if (this.localLoginContext != null) {
                        this.localLoginContext.logout();
                        this.loggedOut = true;
                    } else {
                        logger.finest(" user is not logged, so we don't logout him ");
                    }
                } else if (this.loginContext != null) {
                    this.loginContext.logout();
                    this.loggedOut = true;
                } else {
                    logger.finest(" user is not logged, so we don't logout him ");
                }
            }
            catch (LoginException e) {
                logger.log(Level.SEVERE, " error raised when the user logout " + e.getMessage(), e);
            }
        }
    }

    public boolean isLocal() {
        return this.local;
    }
}

