/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core.authentication;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.AuthenticationBindings;
import net.sf.jguard.core.authentication.AuthenticationUtils;
import net.sf.jguard.core.authentication.ImpersonationAuthenticationBindings;
import net.sf.jguard.core.authentication.Stateful;
import net.sf.jguard.core.authentication.StatefulImpersonationAuthenticationBindings;

public class AuthenticationServicePoint {
    private static final Logger logger = Logger.getLogger(AuthenticationServicePoint.class.getName());

    public static boolean authenticate(AccessContext context, String applicationName, AuthenticationBindings authNBindings) {
        authNBindings.setRequestAttribute(context, "registrationDone", false);
        CallbackHandler cbh = authNBindings.getCallbackHandler(context);
        try {
            AuthenticationUtils authNUtils = authNBindings.getAuthenticationUtils(context);
            authNUtils.login(applicationName, cbh);
            if (authNBindings instanceof Stateful) {
                ((Stateful)((Object)authNBindings)).removeSessionAttribute(context, "authenticationUtils");
                ((Stateful)((Object)authNBindings)).invalidateSession(context);
            }
            boolean result = authNBindings.authenticationSucceed(context);
            if (authNBindings instanceof Stateful) {
                ((Stateful)((Object)authNBindings)).setSessionAttribute(context, "authenticationUtils", authNUtils);
            }
            return result;
        }
        catch (LoginException e) {
            logger.log(Level.FINEST, "authentication failed " + e.getMessage(), e);
            String messageError = null;
            messageError = e.getLocalizedMessage();
            authNBindings.setRequestAttribute(context, "LoginExceptionMessage", messageError);
            authNBindings.setRequestAttribute(context, "LoginExceptionClass", e.getClass());
            return authNBindings.authenticationFailed(context);
        }
    }

    public static boolean authenticateWithImpersonation(AccessContext context, String applicationName, AuthenticationBindings authenticationBindings, Callback[] callbacks) {
        ImpersonationAuthenticationBindings impersonatedAuthenticationBindings = null;
        impersonatedAuthenticationBindings = authenticationBindings instanceof Stateful ? new StatefulImpersonationAuthenticationBindings(authenticationBindings, callbacks) : new ImpersonationAuthenticationBindings(authenticationBindings, callbacks);
        return AuthenticationServicePoint.authenticate(context, applicationName, impersonatedAuthenticationBindings);
    }

    public static boolean authenticateAsGuest(AccessContext context, String applicationName, AuthenticationBindings authenticationBindings) {
        Callback[] callbacks = new Callback[2];
        NameCallback nameCallback = new NameCallback("login");
        nameCallback.setName("guest");
        callbacks[0] = nameCallback;
        PasswordCallback pwdCbk = new PasswordCallback("password", false);
        pwdCbk.setPassword("guest".toCharArray());
        callbacks[1] = pwdCbk;
        return AuthenticationServicePoint.authenticateWithImpersonation(context, applicationName, authenticationBindings, callbacks);
    }
}

