/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jguard.core.Filter;
import net.sf.jguard.core.FilterChainImpl;
import net.sf.jguard.core.Filterable;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.authentication.manager.AuthenticationManagerFactory;
import net.sf.jguard.core.filters.PolicyEnforcementPointFilter;

public class PolicyEnforcementPoint {
    private static final Logger logger = Logger.getLogger(PolicyEnforcementPoint.class.getName());
    private FilterChainImpl filterChain = null;
    private List filters;

    public PolicyEnforcementPoint(Map options) {
        PolicyEnforcementPointFilter pepFilter = new PolicyEnforcementPointFilter(options);
        this.filters = new ArrayList();
        AuthenticationManager authenticationManager = AuthenticationManagerFactory.getAuthenticationManager();
        if (authenticationManager != null && authenticationManager instanceof Filterable) {
            logger.finest("adding authenticationManager filter");
            this.addFilter(((Filterable)((Object)authenticationManager)).getFilter());
        }
        this.addFilter(pepFilter);
    }

    public void process(AccessContext contxt) {
        try {
            this.filterChain = new FilterChainImpl(this.filters);
            this.filterChain.doFilter(contxt);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, t.getMessage(), t);
            throw new IllegalStateException(" an exception has occured ");
        }
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }
}

