/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name:  $
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/

package net.sf.jguard.core.provisioning;

import java.util.HashSet;
import java.util.Set;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.organization.Organization;
import net.sf.jguard.core.principals.PrincipalUtils;

/**
 * a candidate to be an {@link Organization}.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class OrganizationTemplate extends EntityTemplate{
   
    private Set credentials;
    
    private SubjectTemplate subjectTemplate;
    private Long id;
    public static final String ORGANIZATION_TEMPLATE = "organizationTemplate";
    private Set principals;
    
        public OrganizationTemplate(){
            super();
            credentials = new HashSet();
            subjectTemplate = new SubjectTemplate();
            principals = new HashSet();	
        }

        public OrganizationTemplate(Organization organization){
            super();
            credentials = new HashSet(organization.getCredentials());
            principals = organization.getPrincipals();
            subjectTemplate = organization.getSubjectTemplate();
            principals = new HashSet();	
        }
        
 
    
        /**
	 * build an Organization from a validated OrganizationTemplate.
	 * @param orga organization to convert to an Organization instace
	 * @return Organization built
	 */
	public Organization buildOrganization(OrganizationTemplate orga){

		Set principalsForRegisteredUsers = new HashSet();
		principalsForRegisteredUsers.addAll((getPrincipals()));
                Set allCredentials =  new HashSet(orga.getCredentials());
                Set creds = allCredentials;
                Set principalsForOrganization = new HashSet();
                //we add the principals from our organizationTemplate
		principalsForOrganization.addAll((getPrincipals()));
                Organization organization = new Organization();
                organization.setCredentials(creds);
		organization.setPrincipals(principalsForOrganization);
                organization.setSubjectTemplate(orga.getSubjectTemplate());
		return organization;
	}

	/**
	 * build a Subject from a validated SubjectTemplate.
	 * @return subject built
	 */
	public Organization toOrganization(){
		return buildOrganization(this);
	}

  

    /**
     * @param organizationCandidate
     */
    public void validateTemplate(OrganizationTemplate organizationCandidate) {
        if(organizationCandidate==null){
            throw new IllegalArgumentException(" organizationTemplate is null ");
        }
        Set requiredCredentialsFromCandidate = organizationCandidate.getCredentials();
        if(requiredCredentialsFromCandidate==null){
            requiredCredentialsFromCandidate = new HashSet();
            organizationCandidate.setCredentials(requiredCredentialsFromCandidate);
        }
        EntityTemplate.filterCredentialSet(this.credentials,requiredCredentialsFromCandidate);
        
    }

    public SubjectTemplate getSubjectTemplate() {
        return subjectTemplate;
    }

    public void setSubjectTemplate(SubjectTemplate subjectTemplate) {
        this.subjectTemplate = subjectTemplate;
    }

    public Set getCredentials() {
        return credentials;
    }

    public void setCredentials(Set credentials) {
        this.credentials = credentials;
    }

    public Object clone() throws CloneNotSupportedException {
        OrganizationTemplate clone = new OrganizationTemplate();
        clone.setSubjectTemplate((SubjectTemplate)subjectTemplate.clone());
        clone.setPrincipals(PrincipalUtils.clonePrincipalsSet(principals));
        clone.setCredentials(JGuardCredential.cloneCredentialsSet(credentials));
        return clone;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
	public Set getPrincipals() {
		return principals;
	}
	/**
	 * defined the principals automatically granted to the registered user.
	 * @param principals
	 */
	public void setPrincipals(Set principals) {
		this.principals = principals;
	}

	
}
