/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.core.principals;


import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Utility class to instantiate a PersistedPrincipal implementation.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class PrincipalUtils {

	private static final Logger logger = Logger.getLogger(PrincipalUtils.class.getName());

   
	/**
	 * instantiate PersistedPrincipal implementations.
	 * @param className implementation class
	 * @param name
	 * @return PersistedPrincipal implementation instance
	 */
	public static Principal getPrincipal(String className, String name){
		Principal ppal = null;
		Class clazz = null;

		try {
			clazz = Class.forName(className);
		} catch (ClassNotFoundException e) {
			logger.log(Level.SEVERE,"",e);
		}

		Constructor constructor = null;
		try {
			constructor = clazz.getConstructor(new Class[]{String.class});
		} catch (SecurityException e) {
			logger.log(Level.SEVERE,"",e);
		} catch (NoSuchMethodException e) {
			logger.log(Level.SEVERE,"",e);
		}

		if(constructor!= null){
			try {
				ppal = (Principal)constructor.newInstance(new Object[]{name});
			} catch (IllegalArgumentException e) {
				logger.log(Level.SEVERE,"",e);
			} catch (InstantiationException e) {
				logger.log(Level.SEVERE,"",e);
			} catch (IllegalAccessException e) {
				logger.log(Level.SEVERE,"",e);
			} catch (InvocationTargetException e) {
				logger.log(Level.SEVERE,"",e);
			}
		}else{
			throw new IllegalArgumentException(" the provided Class="+className+" has'nt got any constructor with a String argument ");
		}

		return ppal;
	}
        
       


	/**
	 * instantiate PersistedPrincipal implementations
	 * @param clazz implementation class
	 * @param parameterTypes
	 * @param parameterValues
	 * @return instantiated principal
	 */
	public static Principal getPrincipal(Class clazz,Class[] parameterTypes, Object[] parameterValues){
		Principal ppal = null;

		Constructor constructor = null;
		try {
			constructor = clazz.getConstructor(parameterTypes);
		} catch (SecurityException e) {
			logger.log(Level.SEVERE,"",e);
		} catch (NoSuchMethodException e) {
			logger.log(Level.SEVERE,"",e);
		}

		if(constructor!= null){
			try {
				ppal = (Principal)constructor.newInstance(parameterValues);
			} catch (IllegalArgumentException e) {
				logger.log(Level.SEVERE,"",e);
			} catch (InstantiationException e) {
				logger.log(Level.SEVERE,"",e);
			} catch (IllegalAccessException e) {
				logger.log(Level.SEVERE,"",e);
			} catch (InvocationTargetException e) {
				logger.log(Level.SEVERE,"",e);
			}
		}

		return ppal;
	}
        
         /**
          * clone deeply a set of {@link BasePrincipal} subclasses instances. 
          */
         public static Set clonePrincipalsSet(Set principals) throws CloneNotSupportedException{
            Set clonedPrincipals = new HashSet();
            Iterator principalsIterator = principals.iterator();
            while(principalsIterator.hasNext()){
                BasePrincipal ppal = (BasePrincipal)principalsIterator.next();
                clonedPrincipals.add(ppal.clone());
            }
            return clonedPrincipals;
        }
         
         	/**
	 * check principal Set against global Permissions.
	 * @param globalPermissions
	 * @param principals
	 */
	public static void checkPrincipals(Set globalPermissions, Set principals) {
		Iterator itPrincipals = principals.iterator();
           while(itPrincipals.hasNext()){
        	   RolePrincipal tempPrincipal = (RolePrincipal)itPrincipals.next();
               Set permissionsFromTemplate =  tempPrincipal.getAllPermissions();
               if(!globalPermissions.containsAll(permissionsFromTemplate)){
            	   //we remove this principal which contains permissions not present in globalPermissions
                   logger.warning(" principal called "+tempPrincipal.getLocalName()+" has been removed from the SubjectTemplate ");
                   logger.warning(" because it contains permissions not owned by this organization throw its Principals ");
            	   itPrincipals.remove();
               }

           }
	}
}
