/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.core.organization;

import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

import javax.security.auth.Subject;

import net.sf.jguard.core.authentication.AuthenticationException;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.principals.BasePrincipal;
import net.sf.jguard.core.principals.PrincipalUtils;
import net.sf.jguard.core.provisioning.SubjectTemplate;



/**
 * an organization which can own one {@link net.sf.jguard.core.provisioning.SubjectTemplate} .
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 * @author <a href="mailto:tandilero@users.sourceforge.net">Maximiliano Batelli</a>
 */
public class Organization implements BasePrincipal, Cloneable{
        public static final String ID = "id";

	private static final Logger logger = Logger.getLogger(Organization.class.getName());
        private AuthenticationManager authenticationManager;

	protected SubjectTemplate subjectTemplate;
        
        /**
         * these objects are some references to principals present in the AuthenticationManager.
         * some of them can be owned by the Organization, which implies the ability to reorganize them,
         * but without overrule the set of permissions granted via all of its roles references.
         */
        protected Set principals;
        protected Set credentials;
	protected Long id;
        protected Set users;

	public Organization(){
            super();
	}

        public Object clone() throws CloneNotSupportedException{
            Organization clonedOrg = new Organization();
            
            Set clonedPrincipals = PrincipalUtils.clonePrincipalsSet(principals);
            clonedOrg.setPrincipals(clonedPrincipals);
            
            Iterator credentialsIterator = credentials.iterator();
            Set clonedCredentials = new HashSet();
            while(credentialsIterator.hasNext()){
                JGuardCredential cred = (JGuardCredential)credentialsIterator.next();
                clonedCredentials.add(cred.clone());
            }
            clonedOrg.setCredentials(clonedCredentials);
            clonedOrg.setSubjectTemplate((SubjectTemplate)subjectTemplate.clone());
            return clonedOrg;
        }
	public Set getPrincipals() {
		return principals;
	}

	public void setPrincipals(Set principals) {
		this.principals = principals;
	}

        public boolean equals(Object organization){
            
            if(!(organization instanceof Organization)){
                return false;
            }
            Organization orga = (Organization)organization;
            Iterator itCred = this.credentials.iterator();
            JGuardCredential idCred = null;
            while(itCred.hasNext()){
                JGuardCredential cred = (JGuardCredential)itCred.next();
                if(ID.equals(cred.getName())){
                    idCred = cred;
                    break;
                }
            }
            
            if(orga.getCredentials()!=null && orga.getCredentials().contains(idCred)){
                return true;
            } 
                
                
            return false;

        }
        
        public int hashCode(){
            int i = super.hashCode();
            if(credentials!=null){
                i=credentials.hashCode();
            }
            return i;
        }



	
	public void addPrincipal(Principal principal)throws AuthenticationException{
         this.principals.add(principal);
	}

	public void removePrincipal(Principal principal)throws AuthenticationException{
       //remove this Principal
       // in the users which contains the Principal
       Collection users = getUsers();
       Iterator itUsers = users.iterator();
       while(itUsers.hasNext()){
    	   Subject user = (Subject)itUsers.next();
    	   Set ppals = user.getPrincipals();
    	   if(ppals.contains(principal)){
    		   ppals.remove(principal);
    	   }
       }
       this.principals.remove(principal);


	}

	

    public SubjectTemplate getSubjectTemplate() {
        return subjectTemplate;
    }

    public void setSubjectTemplate(SubjectTemplate subjectTemplate) {
        OrganizationUtils.checkSubjectTemplatePrincipals(subjectTemplate,principals);
        this.subjectTemplate = subjectTemplate;
    }

    
    
        /**
	 *
	 * @param user
	 * @return created subject
	 * @throws AuthenticationException
	 */
	public  Subject createUser(SubjectTemplate user)  throws AuthenticationException{
            return authenticationManager.createUser(user, this);
	}

          /**
	 *
	 * @param user
	 * @return created subject
	 * @throws AuthenticationException
	 */
	public  Subject createUser(Subject user)  throws AuthenticationException{
            return authenticationManager.createUser(user, this);
	}


	
	/**
	 * @param cred
	 * @param user
	 * @throws AuthenticationException
	 */
	public  void updateUser(JGuardCredential cred,Subject user)  throws AuthenticationException{
               authenticationManager.updateUser(cred,user);
	}
        
        
        
	public Set getUsers(){
	       return users;
	}
 
     
    
	/**
	 * remove user.
	 * @param user
	 * @throws AuthenticationException
	 */
	public void deleteUser(Subject user)throws AuthenticationException{
            authenticationManager.deleteUser(user);
        }
     
     
      /**
      * add role from this application to user.
      * @param user
      * @param roleName
      * @throws AuthenticationException
      */
     public void addPrincipalToUser(Subject user, String roleName)throws AuthenticationException{
         
     }
     
     
     /**
      * add a role from <strong>any</strong> application <strong>without</strong> check
      * to user.
      * @param user
      * @param roleName
      * @param applicationName
      * @throws AuthenticationException
      */
     public void addPrincipalToUser(Subject user, String roleName,String applicationName) throws AuthenticationException{
         
     }

    public Set getCredentials() {
        return credentials;
    }

    public void setCredentials(Set credentials) {
        this.credentials = credentials;
    }

    /**
     * return the <b>unique</b> name of the organization.
     * this name is the value of the credentrial keyed by 'id'.
     * @return
     */
    public String getName() {
        Iterator it = credentials.iterator();
        String credentialIdValue = "";
        while(it.hasNext()){
            JGuardCredential cred = (JGuardCredential)it.next();
            if(cred.getName().equals(ID)){
                credentialIdValue = (String)cred.getValue();
                break;
            }
        }
        return credentialIdValue;
    }

    public int compareTo(Object object) {
        if(object==null){
            throw new IllegalArgumentException(" object comapred in the compareTo method of Organization class is null");
        }
        if(!(object instanceof Organization)){
            throw new IllegalArgumentException("object is not an Orgnaization instance");
        }
        Organization o1 = (Organization)object;
        return getName().compareTo(o1.getName());
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUsers(Set users) {
        this.users = users;
    }

}
