package net.sf.jguard.core.authorization.permissions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringEscapeUtils;

/**
 * Used to resolve URLPermission with parameters
 * @author <a href="mailto:vberetti@users.sourceforge.net">Vincent Beretti</a>
 */
public class URLParameterCollection implements Serializable{

	private static final long serialVersionUID = -6533685803360570616L;

	private Set parameters;

	private boolean impliesMissingKeyParameters;

	public URLParameterCollection() {
		parameters = new HashSet();
		impliesMissingKeyParameters = false;
	}

	public void add(URLParameter parameter) {
		parameters.add(parameter);
	}

	public boolean implies(URLParameter impliedParameter) {
		Iterator itParameter = parameters.iterator();
		while (itParameter.hasNext()) {
			URLParameter parameter = (URLParameter) itParameter.next();
			if (parameter.impliesKey(impliedParameter.getKey())) {
				if (parameter.impliesValues(impliedParameter.getValue())) {
					return true;
				}else{
					return false;
				}
			}
		}
		// impliedParameter has not been implied for key
		if(!impliesMissingKeyParameters){
			return false;
		}
		return true;
	}

	public boolean getImpliesMissingKeyParameters() {
		return impliesMissingKeyParameters;
	}

	public void setImpliesMissingKeyParameters(
			boolean impliesMissingKeyParameters) {
		this.impliesMissingKeyParameters = impliesMissingKeyParameters;
	}

	public boolean isEmpty(){
		return parameters.isEmpty();
	}

	/**
	 * from an URI and a Permission associated
	 *
	 * @param strParams
	 * @return
	 */
	protected static URLParameterCollection getURLParameters(String strParams) {

		URLParameterCollection parametersCollection = new URLParameterCollection();
		strParams = StringEscapeUtils.unescapeHtml(strParams);
		if (strParams != null && strParams != "") {
			List tokens = Arrays.asList(strParams.split("&"));
			Iterator itTokens = tokens.iterator();
			while (itTokens.hasNext()) {
				String token = (String) itTokens.next();
				String[] parts = token.split("=");
				if (parts.length == 2) {
					URLParameter param = new URLParameter();
					param.setKey(URLPermission.buildRegexpFromString(parts[0]));
					String[] values = parts[1].split(";");
					for (int i=0; i<values.length; i++){
						values[i]=URLPermission.buildRegexpFromString(values[i]);
					}
					param.setValue(values);
					parametersCollection.add(param);
				}else if(parts.length == 1 && "*".equals(parts[0])){
					parametersCollection.setImpliesMissingKeyParameters(true);
				}
			}

		}
		return parametersCollection;
	}

	public int size() {
		return parameters.size();
	}

	public Collection getParameters() {
		return parameters;
	}
        
        public String toString(){
            Iterator itParameters = parameters.iterator();
            int count =0;
            StringBuffer sb = new StringBuffer();
            while(itParameters.hasNext()){
                URLParameter param = (URLParameter) itParameters.next();
                count++;
                sb.append(" param").append(count).append('=');
                sb.append(param.toString());
                sb.append("\n");
            }
            return sb.toString();
        }
}
