/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.core.authorization.permissions;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringEscapeUtils;

/**
 * represents an url key and her associated value.
 * @author <a href="mailto:diabolo512@users.sourceforge.net ">Charles Gay</a>
 * @author <a href="mailto:vberetti@users.sourceforge.net">Vincent Beretti</a>
 */
public class URLParameter implements Serializable,Cloneable{

     /**
	  * serial version id.
	  */
	  private static final long serialVersionUID = 3835156176932384821L;
      private String key = null;

      /**
       * the HttpservlerRequest.getParameterValues() return a values Array.
       * when the URL contains copies of a parameter name,
       * this method return an array of all the values for the same parameter name.
       */
      private String[] value = null;
      private String permissionName = null;

     /**
      * constructor.
      */
     protected URLParameter(){

     }

    /**
     * override the java.lang.Object 's <i>clone</i> method.
     * @return new URLParameter.
     */
    public Object clone()throws CloneNotSupportedException{
        URLParameter param = new URLParameter();
        param.setKey(new String(this.key));
        param.setValue(this.value);
        param.setPermissionName(new String(this.permissionName));
        return param;
    }

	/**
	 * @return
	 */
    protected String getKey() {
		return key;
	}

	/**
	 * @return
	 */
    protected String[] getValue() {
		return value;
	}

    /**
     * concat the array String in a single string with a ";" separator.
     * @return concat String
     */
    protected String getValuesAsString(){
        String[] valuesArray = this.value;
        StringBuffer concatValues=new StringBuffer();
        for(int i=0;i<valuesArray.length;i++){
            if(i!=0){
                concatValues.append(";");
            }
                concatValues.append(valuesArray[i]);
        }
        return concatValues.toString();
    }
	/**
	 * @param string
	 */
    protected void setKey(String string) {
		key = string;
	}

	/**
	 * @param string
	 */
    protected void setValue(String[] string) {
		value = string;
	}

    /**
     * override java.lang.Object's <i>hashCode</i> method.
     * @return int to compare quickly to URLParameters.
     */
    public int hashCode(){
        StringBuffer sb = new StringBuffer(this.key);
        sb.append(this.getValuesAsString());
        return sb.toString().hashCode();
    }


    /**
     * override Object equals method.
     */
    public boolean equals(Object obj){
        if(!(obj instanceof URLParameter)){
            return false;
        }
        URLParameter urlp = (URLParameter)obj;


        if(urlp.getKey().equals(this.key)==false){
            return false;
        }

        String[]  targetArray = urlp.getValue();
        String[]  myArray = this.value;

        if(myArray.length !=targetArray.length){
            return false;
        }
        //we sort these String arrays before comparing them
        Arrays.sort(targetArray);
        Arrays.sort(myArray);
        for(int i=0;i< myArray.length;i++){
            if(!(myArray[i]).equals(targetArray[i])){
                return false;
            }
        }

        return true;
    }





	/**
	 * @return
	 */
    protected String getPermissionName() {
		return permissionName;
	}

	/**
	 * @param string
	 */
    protected void setPermissionName(String string) {
		permissionName = string;
	}

	/**
	 * from an URI and a Permission associated
	 * @param uri
	 * @return
	 */
    protected static Set getURLParameters(URI uri){

		Set parameters = new HashSet();
	       String query = uri.getQuery();
	       query = StringEscapeUtils.unescapeHtml(query);
		   if(query!=null && query!=""){
	       List tokens = Arrays.asList(query.split("&"));
	       Iterator itTokens = tokens.iterator();
		       while(itTokens.hasNext()){
		           String token = (String)itTokens.next();
		           String[] parts = token.split("=");
				   if(parts.length==2){
			           URLParameter param = new URLParameter();
			           param.setKey(parts[0]);
			           String[] values = parts[1].split(";");
			           param.setValue(values);
			           parameters.add(param);
				   }
	           }

		   }
		   return parameters;
	}

	public boolean impliesKey(String key) {
		String regexpKey = this.key.replaceAll("\\*","\\.\\*");
		if(!key.equals(this.key) && !Pattern.matches(regexpKey, key)){
            return false;
        }
		return true;
	}

	public boolean impliesValues(String[] value) {
		if(value.length != this.value.length){
            return false;
        }
        //we sort these String arrays before comparing them
        Arrays.sort(value);
        Arrays.sort(this.value);
        for(int i=0;i< value.length;i++){
    		String regexpValue = this.value[i].replaceAll("\\*","\\.\\*");
            if(!(value[i]).equals(this.value[i]) && !Pattern.matches(regexpValue, value[i])){
                return false;
            }
        }
        return true;
	}
        
        public String toString(){
            StringBuffer sb = new StringBuffer();
            sb.append("key=").append(key).append("  ");
            sb.append("value=").append(getValuesAsString());
            return sb.toString();
        }
}
