/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.core.authorization.permissions;


import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;


/**
 * regroups Permissions (in a 'functional' way) as a JGPositivePermissionCollection
 *  (additive mechanism).it differs from JGPermissionCollection 
 *  which regroups Permission in a technical way, by owning a name which
 *  refers to functional resources.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 *
 */
public class Domain extends JGPermissionCollection implements Comparable,Cloneable,Serializable{

	private static final long serialVersionUID = 178066544850786962L;

    private String name;


    public Domain(String domainName){
    	super();
        name = domainName;
    }
    public Domain(String domainName,PermissionCollection pcoll){
        name = domainName;
        permissions = new HashSet();
        super.addAll(pcoll);
    }
    /**
     * @return Returns the domainName.
     */
    public String getName() {
        return name;
    }
    /**
     * @param domainName The domainName to set.
     */
    public void setName(String domainName) {

        this.name = domainName;
    }

    /**
     * override the <i>equals</i> method inherited from Object.
     * @param obj an Domain
     * @return true if equals, false otherwise
     */
    public boolean equals(Object obj){
        Domain domain = (Domain)obj;
        if(this.name.equals(domain.getName())){
            return true;
        }
        return false;
    }

    /**
     * methode used to accelerate the comparation process:
     *  useful when hashcode return different int.
     *  it uses hashcode of the name.
     * @return hashcode
     */
    public int hashCode() {
        return name.toString().hashCode();
    }


    /**
     * override the java.lang.Object 's <i>clone</i> method.
     * @return new Domain
     */
    public Object clone()throws CloneNotSupportedException{
       JGPermissionCollection dom = new Domain(new String(this.name));
       Set perms = new HashSet();
       Iterator itPermissions = permissions.iterator();
       while(itPermissions.hasNext()){
           Permission perm = (Permission)itPermissions.next();
           String permName = perm.getName();
           String permActions = perm.getActions();
           Class permClass = perm.getClass();
           Permission newPerm;
		try {
			newPerm = PermissionUtils.getPermission(permClass.getName(),permName,permActions);
		} catch (ClassNotFoundException e) {
			throw new CloneNotSupportedException(e.getMessage());
		}
           perms.add(newPerm);
       }
       dom.setPermissions(perms);
       return dom;
    }

    /**
     * compare name with the name of the specified object for order.
     * @param o the Domain to compare
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(Object o) {
       Domain domain = (Domain)o;
       return this.name.compareTo(domain.getName());
    }


    /**
     * convert object into a string representation.
     * @return string representation
     */
    public String toString(){
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append(" name="+name);
        sb.append("\n");
        sb.append(" permissions=\n"+super.toString());
        sb.append("\n");
        return sb.toString();
    }
    
    public boolean implies(Permission permission){
	    Iterator it = permissions.iterator();
		Permission p;
	
	    while(it.hasNext()){
			p = (Permission) it.next();
			if (p.implies(permission)) {
				return true;
			}
		}
		return false;
	}

}
