/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/


package net.sf.jguard.core.authorization;

import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.Policy;
import java.util.logging.Logger;

import javax.security.auth.Subject;

import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authorization.policy.AccessControllerUtils;
import net.sf.jguard.core.authorization.policy.JGuardPolicy;

/**
 * point which decides if access is granted or not.
 * this class uses the {@link AutorizationBindings} to know permission wanted and follow its decision.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class PolicyDecisionPoint {
    
    private static final Logger logger = Logger.getLogger(PolicyDecisionPoint.class.getName());
    private AuthorizationBindings authorizationBindings = null;
    
    /** Creates a new instance of AuthorizationLifeCycle */
    public PolicyDecisionPoint(AuthorizationBindings phases) {
       this.authorizationBindings = phases;

    }
    
    /**
     * add a security check.
     */
     public void process(AccessContext context){
         Permission permission = authorizationBindings.getPermissionRequested(context);
         Subject subject = Subject.getSubject(AccessController.getContext());
         
           if(!AccessControllerUtils.hasPermission(subject,permission)){
        	   //we store the last access denied URI before authentication
            	//to redirect to this permission after successful authentication
            	authorizationBindings.setLastAccessDeniedPermission(context,permission);
            	logger.finest(" accessdenied phase ");
                authorizationBindings.accessDenied(context);
            }else{
            	//access granted
            	logger.finest(" authorize access to resource protected by permission "+permission.getClass().getName()+" name="+permission.getName()+" actions="+permission.getActions());
                authorizationBindings.authorize(context);
            }
     }
     
     
     public void addAlwaysGrantedPermissionsToPolicy(Permissions alwaysGrantedPermissions) {
 		if(alwaysGrantedPermissions==null){
 			return;
 		}
 		Policy policy = AccessControllerUtils.getPolicy();
 		if(JGuardPolicy.class.isAssignableFrom(policy.getClass())) {
 			JGuardPolicy jgPolicy = (JGuardPolicy) policy;
 			ClassLoader cl = Thread.currentThread().getContextClassLoader();
 			jgPolicy.addAlwaysGrantedPermissions(cl,alwaysGrantedPermissions);	
 		}else{
 			throw new UnsupportedOperationException(" the current java.security.Policy subclass is not a subclass of net.sf.jguard.core.authorization.policy.JGuardPolicy ");
 		}
 	}

	public AuthorizationBindings getAuthorizationBindings() {
		return authorizationBindings;
	}
         
}
