/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.core.authentication.manager;



import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import net.sf.jguard.core.authentication.AuthenticationException;



/**
 * build an AuthenticationManager implementation.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class AuthenticationManagerFactory {

    private static AuthenticationManager authenticationManager;
    private static Logger logger = Logger.getLogger(AuthenticationManagerFactory.class.getName());

    /**
     * Convenience method that returns the current AuthenticationManager.
     * implementation.
     *
     * @return authenticationManager or<code><strong>null</strong></code> when
     * no authenticationManager is created.
     */
    public static AuthenticationManager getAuthenticationManager() {
        return authenticationManager;
    }

    /**
     * initialize the DAO implementation.
     * @param authenticationManagerImpl
     * @param map
     * @return <code>true</code> if AuthenticationManager is created successfully, <code>false</code> otherwise
     * @throws AuthenticationException
     */
    public static AuthenticationManager createAuthenticationManager(Class authenticationManagerImpl,Map map) throws AuthenticationException{
           logger.info("authenticationManagerImpl="+authenticationManagerImpl.getName());
           AuthenticationManager authenticationManager;
           if(authenticationManagerImpl==null){
        	   throw new AuthenticationException(" authenticationManager implementation is null or empty "+authenticationManagerImpl);
           }
           
            Constructor constructor;
            try {
                constructor = authenticationManagerImpl.getConstructor(new Class[] {Map.class});
                authenticationManager = (AuthenticationManager)constructor.newInstance(new Object[]{map});
            } catch (InvocationTargetException ex) {
                logger.log(Level.SEVERE,ex.getMessage(),ex);
                throw new AuthenticationException(" InstantiationException "+ex.getMessage(),ex);
            } catch (InstantiationException e) {
                logger.log(Level.SEVERE,e.getMessage(),e);
                throw new AuthenticationException(" InstantiationException "+e.getMessage(),e);
            } catch (IllegalAccessException e) {
                logger.log(Level.SEVERE,e.getMessage(),e);
                throw new AuthenticationException(" IllegalAccessException "+e.getMessage(),e);
            } catch (SecurityException e) {
                logger.log(Level.SEVERE,e.getMessage(),e);
                throw new AuthenticationException(" SecurityException "+e.getMessage(),e);
            } catch (NoSuchMethodException e) {
                logger.log(Level.SEVERE,e.getMessage(),e);
                throw new AuthenticationException(" NoSuchMethodException "+e.getMessage(),e);
            }
            
            return authenticationManager;
        }

	public static void setAuthenticationManager(
			AuthenticationManager authenticationManager) {
		AuthenticationManagerFactory.authenticationManager = authenticationManager;
	}
	
	
}
