/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.core.authentication.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

import net.sf.jguard.core.CoreConstants;


/**
 * utility class to deal with the {@link javax.security.auth.login.Configuration} class.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class ConfigurationHelper {
	 
	 private static String scope;
	 
	 
	 private static boolean configurationInstalled = false;
     private static Logger logger = Logger.getLogger(ConfigurationHelper.class.getName());
     private final static String COM_SUN_SECURITY_AUTH_LOGIN_CONFIG_FILE = "com.sun.security.auth.login.ConfigFile";

	/**
     * add the required AppConfigurationEntry when no none is configured for the webapp.
     * @param applicationName
     * @param authenticationSettings
     * @param debug
     */
    public static void addConfigurationEntryForWebapp(JGuardConfiguration configuration,String applicationName,Map authenticationSettings,boolean debug){
        List webappEntries = buildAppConfigurationEntries(applicationName,authenticationSettings,debug);
        configuration.addConfigEntriesForApplication(applicationName,webappEntries);
    }


    /**
     * install JGuardConfiguration.
     * @param includeOldConfiguration include informations contained in the replaced configuration instance
     * @param includeConfigFromJavaParam
     * @throws RuntimeException
     */
	public static void installConfiguration(boolean includeOldConfiguration,boolean includeConfigFromJavaParam) throws RuntimeException {
		if(!configurationInstalled){
			includeConfigFromJavaParam = false;
		}
			JGuardConfiguration jGuardConf = installWithOldConfig(includeOldConfiguration);
		
        if(includeConfigFromJavaParam){
        	//TODO build a Configuration object to include from the configuration file
        	try {
				Class defaultConfigClass = Class.forName(ConfigurationHelper.COM_SUN_SECURITY_AUTH_LOGIN_CONFIG_FILE);
				Configuration defaultConfiguration = (Configuration) defaultConfigClass.newInstance();
	        	jGuardConf.includeConfiguration(defaultConfiguration);
			} catch (ClassNotFoundException e) {
				logger.log(Level.SEVERE,ConfigurationHelper.COM_SUN_SECURITY_AUTH_LOGIN_CONFIG_FILE+" class cannot be found "+e.getMessage(),e);
			} catch (InstantiationException e) {
				logger.log(Level.SEVERE,ConfigurationHelper.COM_SUN_SECURITY_AUTH_LOGIN_CONFIG_FILE+" class cannot be instantiated "+e.getMessage(),e);
			} catch (IllegalAccessException e) {
				logger.log(Level.SEVERE,ConfigurationHelper.COM_SUN_SECURITY_AUTH_LOGIN_CONFIG_FILE+" class cannot be accessed "+e.getMessage(),e);
			}

        }

	}


    /**
     *
     * @param includeOldConfiguration
     * @return
     * @throws RuntimeException
     */
	private static JGuardConfiguration installWithOldConfig(boolean includeOldConfiguration) throws RuntimeException {
		JGuardConfiguration jGuardConf;
		Configuration oldConfiguration = null;
        boolean skipOldConfig = false;
        try{
          oldConfiguration = Configuration.getConfiguration();
          logger.log(Level.FINE," oldConfiguration="+oldConfiguration.getClass().getName());
          logger.log(Level.FINE," oldConfiguration="+oldConfiguration);

        }catch(SecurityException sex){
          skipOldConfig = true;
          logger.log(Level.FINE," addConfigurationEntryForWebapp() -  exception raised when we try to retrieve the default Configuration instance ");
          logger.log(Level.FINE," addConfigurationEntryForWebapp() - "+ sex.getMessage());
          logger.log(Level.FINE," jGuard will not include the old Configuration ");
        }catch(NullPointerException npe){
            skipOldConfig = true;
            logger.log(Level.FINE,"addConfigurationEntryForWebapp() - a NullPointerException has been raised when the default configuration :no configuration is defined ");
            logger.log(Level.FINE,"addConfigurationEntryForWebapp() - "+ npe.getMessage());
        }

        //we override the current Configuration to JGuardConfiguration
        //only if the current Configuration is not a JGuardConfiguration instance
        if(oldConfiguration== null ||
        		(!oldConfiguration.getClass().getName().equals(JGuardConfiguration.class.getName()))){
	          jGuardConf = new JGuardConfiguration();
	          Configuration.setConfiguration(jGuardConf);
	          logger.log(Level.INFO," JGuardConfiguration is set ");
	    //it is a JGuardConfiguration but with a class not loaded with this classloader
        }else if(!oldConfiguration.getClass().equals(JGuardConfiguration.class)
        		 && oldConfiguration.getClass().getName().equals(JGuardConfiguration.class.getName())){
        	logger.log(Level.SEVERE," jGuard_jvm must be placed under the shared libraries directory or on the jvm side, not in the WEB-INF/lib directory of the webapp ");
        	throw new RuntimeException(" jGuard_jvm must be placed under the shared libraries directory or on the jvm side, not in the WEB-INF/lib directory of the webapp ");
        }else{
          jGuardConf = (JGuardConfiguration) Configuration.getConfiguration();
          logger.log(Level.FINE,"configuration="+oldConfiguration.getClass().getName());
          logger.log(Level.FINE," JGuardConfiguration is already set ");
      	  // we don't include the old Configuration
      	  //because the old Configuration is kept: it's already a jGuardConfiguration
      	  skipOldConfig = true;
        }

        //there is no configuration entries for the webapp
        if(!skipOldConfig && includeOldConfiguration == true){
        	logger.log(Level.INFO," jGuard include the old Configuration ");
           jGuardConf.includeConfiguration(oldConfiguration);
        }

        //we should only execute one time this method per webapp
        configurationInstalled = true;
        return jGuardConf;
	}


    /**
     * build the list of AppConfigurationEntry.
     * @param applicationName
     * @param authSettings
     * @param debug
     * @return list built
     */
    private static List buildAppConfigurationEntries(String applicationName,Map authSettings,boolean debug) {
    	List appConfigurationEntryList = new ArrayList();

        List loginModules = (List)authSettings.get(CoreConstants.LOGIN_MODULES);
        if(loginModules==null){
        	throw new IllegalArgumentException(" no loginModules have been configured for the application="+applicationName);
        }
        Iterator itLoginModules = loginModules.iterator();
        while(itLoginModules.hasNext()){
               Map loginModuleMap = (Map)itLoginModules.next();
               String loginModuleClassName = (String)loginModuleMap.get(CoreConstants.NAME);
               String loginModuleFlag = (String)loginModuleMap.get(CoreConstants.FLAG);
               AppConfigurationEntry.LoginModuleControlFlag controlFlag;
               if(loginModuleFlag.equalsIgnoreCase(CoreConstants.REQUIRED)){
                   controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
               }else if(loginModuleFlag.equalsIgnoreCase(CoreConstants.OPTIONAL)){
                   controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
               }else if(loginModuleFlag.equalsIgnoreCase(CoreConstants.REQUISITE)){
                   controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
               }else if(loginModuleFlag.equalsIgnoreCase(CoreConstants.SUFFICIENT)){
                   controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
               }else{
            	   throw new IllegalArgumentException(" invalid loginModuleControlFlag ="+loginModuleFlag+" is neither OPTIONAL,REQUIRED,REQUISITE nor SUFFICIENT ");
               }
               Map loginModuleOptions = (Map)loginModuleMap.get(CoreConstants.LOGIN_MODULE_OPTIONS);
               loginModuleOptions.put(CoreConstants.APPLICATION_NAME,applicationName);
               AppConfigurationEntry entry = new AppConfigurationEntry(loginModuleClassName,controlFlag,loginModuleOptions);
               appConfigurationEntryList.add(entry);
        }
        if(appConfigurationEntryList.size()==0){
        	throw new IllegalArgumentException(" no loginModules have been configured for the application="+applicationName);
        }
        return appConfigurationEntryList;
    }


	public static String getScope() {
		return scope;
	}



}
