/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.core.authentication.callbacks;

import java.io.IOException;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

/**
 * {@link CallbackHandler} implementation which permit directly to assign
 * the callback to the loginModules. the main purpose to this calbackhandler,
 * is to 'hook' the CallbackHandler purpopse to prevent  to grab in the 
 * protocol the required callbacks; it is used when you want to set directly
 * the credentials for the user. one use case is to create a GUEST user
 * with some GUEST credentials.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 *
 */
public class HookCallbackHandler implements CallbackHandler {

	private Callback[] callbacks;
	
	public HookCallbackHandler(Callback[] cbks){
		this.callbacks = cbks;
	}
	
	public void handle(Callback[] callbacksToReplace) throws IOException,
			UnsupportedCallbackException {
		for(int i = 0;i<callbacksToReplace.length;i++){
			Callback cbk = callbacksToReplace[i];
			callbacksToReplace[i] = replaceCallback(cbk);
		}

	}

	/**
	 * we try to replace the needed callback by
	 * the one provided in the constructor, if their class are 
	 * equals. otherwise, we return the one provided in argument.
	 * @param callbackToReplace
	 * @return
	 */
	private Callback replaceCallback(Callback callbackToReplace){
		Class clazz = callbackToReplace.getClass();
		for(int i=0;i<callbacks.length;i++){
			if(callbacks[i].getClass().equals(clazz)){
				return callbacks[i];
			}
		}
		return callbackToReplace;
	}
}
