/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.core.authentication;

import java.security.Permission;
import java.security.Permissions;
import java.util.Collection;

import javax.security.auth.callback.CallbackHandler;

/**
 * this class implements the Wrapper/decorator pattern to override
 * some methods implemented by the internal {@link AuthenticationBindings}
 * wrapped in the constructor.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class AuthenticationBindingsWrapper implements AuthenticationBindings {

	protected AuthenticationBindings authNBindings = null;
	public AuthenticationBindingsWrapper(AuthenticationBindings authenticationBindings){
		this.authNBindings = authenticationBindings;
	}
	
	public boolean authenticationFailed(AccessContext context) {
		return authNBindings.authenticationFailed(context);
	}

	public boolean authenticationSucceed(AccessContext context) {
		return authNBindings.authenticationSucceed(context);
	}

	public Object getApplicationAttribute(AccessContext context, String key) {
		return authNBindings.getApplicationAttribute(context,key);
	}

	public Collection getAuthSchemes() {
		return authNBindings.getAuthSchemes();
	}

	public Permission getAuthenticationFailedPermission() {
		return authNBindings.getAuthenticationFailedPermission();
	}

	public AuthenticationUtils getAuthenticationUtils(AccessContext context) {
		return authNBindings.getAuthenticationUtils(context);
	}

	public CallbackHandler getCallbackHandler(AccessContext context) {
		return authNBindings.getCallbackHandler(context);
	}

	public Permissions getGrantedPermissions() {
		return authNBindings.getGrantedPermissions();
	}

	public Permission getIndexPermission() {
		return authNBindings.getIndexPermission();
	}

	public Permission getLogoffPermission() {
		return authNBindings.getLogoffPermission();
	}

	public Permission getLogonPermission() {
		return authNBindings.getLogonPermission();
	}

	public Permission getLogonProcessPermission() {
		return authNBindings.getLogonProcessPermission();
	}

	public Object getRequestAttribute(AccessContext context, String key) {
		return authNBindings.getRequestAttribute(context,key);
	}

	public void init(String location, String authenticationScope) {
		authNBindings.init(location, authenticationScope);
	}

	
	public void process(AccessContext context) {
		authNBindings.process(context);
	}


	public void setApplicationAttribute(AccessContext context, String key,
			Object value) {
		authNBindings.setApplicationAttribute(context, key,value);
	}

	public void setRequestAttribute(AccessContext context, String key,
			Object value) {
		authNBindings.setRequestAttribute(context, key,value);

	}

	

	public void removeApplicationAttribute(AccessContext context, String key) {
		authNBindings.removeApplicationAttribute(context, key);
	}

	public void removeRequestAttribute(AccessContext context, String key) {
		authNBindings.removeRequestAttribute(context, key);
	}

	public boolean isStateful() {
		return authNBindings.isStateful();
	}

}
