/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/


package net.sf.jguard.core.authentication;

import java.security.Permission;
import java.security.Permissions;
import java.util.Collection;

import javax.security.auth.callback.CallbackHandler;




/**
 * Authentication bindings with the underlying protocol and server technology
 * used by the {@link PolicyEnforcementPoint}.
 * Note that implementation of this interface <strong>DOES NOT</strong>
 * authenticate any entity.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 * @see PolicyEnforcementPoint
 * @see AuthenticationServicePoint
 * @since 1.1
 */
public interface AuthenticationBindings {
    
    
   public void init(String location,String authenticationScope);
   
   //actions
   public void process(AccessContext context);
   
   public boolean authenticationFailed(AccessContext context);
   public boolean authenticationSucceed(AccessContext context);

   public CallbackHandler getCallbackHandler(AccessContext context);
   
   
   //request specific method
   public void setRequestAttribute(AccessContext context,String key,Object value);
   public Object getRequestAttribute(AccessContext context,String key);
   public void removeRequestAttribute(AccessContext context,String key);
   

   //application specific method 
   public void setApplicationAttribute(AccessContext context,String key,Object value);
   public Object getApplicationAttribute(AccessContext context,String key);
   public void removeApplicationAttribute(AccessContext context,String key);
   
   /**
    * if this method return true, implementation <strong>MUST</strong> implements 
    * the {@link Stateful} interface.
    * @return
    */
   public boolean isStateful();

   public AuthenticationUtils getAuthenticationUtils(AccessContext context);
   
   //permissions
   public Permission getAuthenticationFailedPermission();
   public Permission getLogonPermission();
   public Permission getLogonProcessPermission();
   public Permission getLogoffPermission();
   public Permission getIndexPermission();
   public Permissions getGrantedPermissions();
   
   //authentication Schemes
   public Collection getAuthSchemes();
  
}
