/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/

package net.sf.jguard.core.authentication;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * contains a Map of identified Keys to reach some Objects bound in some specific contexts.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 */
public class AccessContext implements Cloneable{
    
    private Map parameters;
    
    /** Creates a new instance of Context */
    public AccessContext() {
       parameters = new HashMap();
    }

    public Object  getAttribute(String key) {
        return parameters.get(key);
    }

    public void setAttribute(String key, Object value) {
        parameters.put(key,value);
    }
    
    /**
     * return a cloned context containing a shallow copy of the internal Map:
     * keys and values themselves are not cloned.
     */
    public Object clone(){
    	AccessContext context = new AccessContext();
    	Iterator it = parameters.keySet().iterator();
    	while(it.hasNext()){
    		String key = (String)it.next(); 
    		Object value = parameters.get(key);
    		context.setAttribute(key, value);
    	}
    	return context;
    }
    
  
}
