/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name$
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;


import java.util.logging.Logger;
import net.sf.jguard.core.authentication.AccessContext;
import net.sf.jguard.core.authentication.manager.AuthenticationManager;
import net.sf.jguard.core.authentication.manager.AuthenticationManagerFactory;
import net.sf.jguard.core.filters.PolicyEnforcementPointFilter;


/**
 * Policy Enforcement Point.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles Gay</a>
 * @since 1.1
 */
public class PolicyEnforcementPoint {

    private static final Logger logger = Logger.getLogger(PolicyEnforcementPoint.class.getName());
    private FilterChainImpl filterChain = null;
    private List filters;
    public PolicyEnforcementPoint(Map options){

       PolicyEnforcementPointFilter pepFilter = new PolicyEnforcementPointFilter(options);
       filters = new ArrayList();
       AuthenticationManager authenticationManager = AuthenticationManagerFactory.getAuthenticationManager();
       if(authenticationManager!=null && authenticationManager instanceof Filterable){
           logger.finest("adding authenticationManager filter");
           addFilter(((Filterable)authenticationManager).getFilter());
       }
       addFilter(pepFilter);
    }
    
         
    /**
     * check if user is authenticated, and check its access rights.
     * @param contxt
     */
	public void process(AccessContext contxt){
		try{
                    filterChain = new FilterChainImpl(filters);
                    filterChain.doFilter(contxt);
                }catch(Throwable t){
                    logger.log(Level.SEVERE,t.getMessage(),t);
                    throw new IllegalStateException(" an exception has occured ");
                }

	}
 
       public void addFilter(Filter filter){
            filters.add(filter);
        }

}
