/*
jGuard is a security framework based on top of jaas (java authentication and authorization security).
it is written for web applications, to resolve simply, access control problems.
version $Name:  $
http://sourceforge.net/projects/jguard/

Copyright (C) 2004  Charles GAY

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


jGuard project home page:
http://sourceforge.net/projects/jguard/

*/
package net.sf.jguard.core;


/**
 * Constants used in core lib.
 * @author <a href="mailto:diabolo512@users.sourceforge.net">Charles GAY</a>
 */
public interface CoreConstants {


	public final static String APPLICATION_NAME = "applicationName";
	public final static String DEBUG = "debug";
	public final static String REQUIRED = "REQUIRED";
	public final static String OPTIONAL = "OPTIONAL";
	public final static String REQUISITE = "REQUISITE";
	public final static String SUFFICIENT= "SUFFICIENT";


	public final static String INCLUDE_OLD_CONFIG = "includeOldConfig";
	public final static String INCLUDE_CONFIG_FROM_JAVA_PARAM = "includeConfigFromJavaParam";


	public final static String LOGIN_MODULES= "loginModules";
	public static final String LOGIN_MODULE_OPTIONS = "loginModuleOptions";

	public static final String FLAG = "flag";
	public static final String NAME = "name";

	//guest id
	public final static String GUEST = "guest";
	public static final String DEFAULT_APPLICATION_NAME="other";
	public final static String LAST_ACCESS_DENIED_PERMISSION = "lastAccessDeniedPermission";
	public static final String REGISTRATION_DONE = "registrationDone";
	public static final String LOGIN_EXCEPTION_CLASS = "LoginExceptionClass";
	public static final String LOGIN_EXCEPTION_MESSAGE = "LoginExceptionMessage";
	public final static String AUTHN_UTILS = "authenticationUtils";
	public final static String AUTHENTICATION_BINDINGS="authenticationBindings";
	public final static String AUTHORIZATION_BINDINGS="authorizationBindings";
	public final static String PROVISIONING_SERVICE_POINT="provisioningServicePoint";
	//configuration location
	public final static String CONFIGURATION_LOCATION="configurationLocation";
	public static final Object AUTHENTICATION_SCOPE = "authenticationScope";


}
