package net.sf.javaprinciples.data.visitor;

/**
 *
 * @author Warwick Slade
 */
public class ConditionalNode implements Node
{
    private Node test;
    private Node trueNode;
    private Node falseNode;

    @Override
    public void accept(Visitor visitor)
    {
        if (test(visitor))
        {
            trueNode.accept(visitor);
        }
        else
        {
            falseNode.accept(visitor);
        }
    }

    private boolean test(Visitor visitor)
    {
        VisitorImpl testVisitor = new VisitorImpl(visitor);
        test.accept(testVisitor);

        Object[] operands = testVisitor.getOperands();
        if (operands.length + 1 == visitor.getOperands().length)
        {
            throw new RuntimeException("One more operand expected from visiting test node");
        }
        return (Boolean)operands[visitor.getOperands().length + 1];
    }

    public void setTrue(Node trueNode)
    {
        this.trueNode = trueNode;
    }

    public void setFalse(Node falseNode)
    {
        this.falseNode = falseNode;
    }

    public void setTest(Node test)
    {
        this.test = test;
    }
}
