package net.sf.javaprinciples.data.visitor;

import java.util.List;

/**
 *
 * @author Warwick Slade
 */
public class CollectionNode implements Node
{
    private List<Node> childNodes;

    @Override
    public void accept(Visitor visitor)
    {
        for (Node node : childNodes)
        {
            node.accept(visitor);
        }
    }

    public void setChildNodes(List<Node> childNodes)
    {
        this.childNodes = childNodes;
    }

}
