package net.sf.javaprinciples.data.transformer.spring;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.springframework.core.convert.converter.Converter;
import org.springframework.util.ClassUtils;

/**
 * An extension of spring class to handle Jaxb enums with values.
 * @author Warwick Slade
 * @since 3.0
 */
public final class JaxbEnumToStringConverter implements Converter<Enum<?>, String>
{

    public String convert(Enum<?> source)
    {
        Method valueMethod = ClassUtils.getMethodIfAvailable(source.getClass(), "value", null);
        if (valueMethod == null)
        {
            return source.name();
        }
        else
        {
            try
            {
                return (String)valueMethod.invoke(source);
            }
            catch (IllegalAccessException e)
            {
                return "";

            }
            catch (InvocationTargetException e)
            {
                return "";
            }
        }
    }

}
