package net.sf.javaprinciples.data.transformer;

import net.sf.javaprinciples.data.visitor.Node;
import net.sf.javaprinciples.data.visitor.Visitor;
import net.sf.javaprinciples.data.visitor.VisitorImpl;

/**
 *
 * @author Warwick Slade
 */
public class ValidationRoot<T> implements Validation<T>
{
    private Node node;

    @Override
    public ValidationResult validate(T input)
    {
        Visitor visitor = new VisitorImpl(input);

        node.accept(visitor);
        return (ValidationResult)visitor.getOperands()[1];
    }

    public void setNode(Node node)
    {
        this.node = node;
    }
}
