package net.sf.javaprinciples.data.transformer;

import net.sf.javaprinciples.data.visitor.Node;
import net.sf.javaprinciples.data.visitor.Visitor;
import net.sf.javaprinciples.data.visitor.VisitorImpl;

/**
 *
 * @author Warwick Slade
 */
public class TransformerRoot<T, V> implements Transformer<T, V>
{
    private Node node;

    @Override
    public V transform(T input)
    {
        Visitor visitor = new VisitorImpl(input);

        node.accept(visitor);
        return (V)visitor.getOperands()[1];
    }

    public void setNode(Node node)
    {
        this.node = node;
    }
}
