package net.sf.javaprinciples.data.transformer;

import java.util.List;

import net.sf.jcc.model.parser.UnexpectedException;
import net.sf.jcc.model.parser.uml2.ElementStore;
import net.sf.jcc.model.parser.uml2.ModelElement;

/**
 *
 * @author Kay Chevalier
 */
public class TransformerFactoryImpl<T,V> implements TransformerFactory
{
    private List<TransformerDetails> registeredTransformers;

    public Transformer<T,V> createTransformer(String transformerId, TransformerFactory.DIRECTION_TYPE direction)
    {
        TransformerDetails transformerDetails = getTransformerDetails(transformerId);
        if (transformerDetails == null)
            return null;

        ElementStore store = transformerDetails.getStore();
        ModelElement sourceModelElement = store.get(transformerDetails.getSourceGuid());
        ModelElement targetModelElement = store.get(transformerDetails.getTargetGuid());

        ModelElementTransformer<T, V> modelElementTransformer = new ModelElementTransformer<T, V>();
        modelElementTransformer.setStore(store);
        modelElementTransformer.setSourceModelElement(sourceModelElement);
        modelElementTransformer.setTargetModelElement(targetModelElement);
        return modelElementTransformer;
    }

    private TransformerDetails getTransformerDetails(String transformerId)
    {
        if (registeredTransformers != null)
        {
            for (TransformerDetails transformerDetails : registeredTransformers)
            {
                if (transformerDetails.getTransformerId().equals(transformerId))
                    return transformerDetails;
            }
        }

        throw new UnexpectedException("No registered transformers exist for transformer id " + transformerId);
    }

    public void setRegisteredTransformers(List<TransformerDetails> registeredTransformers)
    {
        this.registeredTransformers = registeredTransformers;
    }
}
