package net.sf.javaprinciples.data.transformer;

import net.sf.javaprinciples.data.property.PropertySource;

/**
 * Obtain a value from a source and place in a target.
 *
 * @author Warwick Slade
 */
public class PropertyValidation<T, V> implements Validation<T>
{
    private PropertySource<T, V> propertySource;
    private String name;

    @Override
    public ValidationResult validate(T input)
    {
        V value = propertySource.getProperty(input);
        // TODO Implement a validation operation
        return value != null ? new ValidationResult() : new ValidationResult(name, ValidationResult.REQUIRED);
    }

    public void setPropertySource(PropertySource<T, V> propertySource)
    {
        this.propertySource = propertySource;
    }

    public void setName(String name)
    {
        this.name = name;
    }
}
