package net.sf.javaprinciples.data.transformer;

import net.sf.javaprinciples.data.property.PropertySource;
import net.sf.javaprinciples.data.property.PropertyTarget;

/**
 * Obtain a value from a source and place in a target.
 *
 * @author Warwick Slade
 */
public class PropertyMapper<T, U, V> implements Mapper<T, U>
{
    private PropertySource<T, V> propertySource;
    private PropertyTarget<U, V> propertyTarget;

    @Override
    public void map(T input, U output)
    {
        V value = propertySource.getProperty(input);
        propertyTarget.setProperty(output, value);
    }

    public void setPropertySource(PropertySource<T, V> propertySource)
    {
        this.propertySource = propertySource;
    }

    public void setPropertyTarget(PropertyTarget<U, V> propertyTarget)
    {
        this.propertyTarget = propertyTarget;
    }
}
