package net.sf.javaprinciples.data.transformer;

import net.sf.javaprinciples.data.property.PropertySource;

/**
 * Obtain a value from a source and place in a target.
 *
 * @author Warwick Slade
 */
public class PropertyDiff<T, V> implements Diff<T>
{
    private PropertySource<T, V> propertySource;
    private String name;

    @Override
    public DiffResult diff(T left, T right)
    {
        V valueLeft = propertySource.getProperty(left);
        V valueRight = propertySource.getProperty(right);
        // TODO Implement a equivalence operation
        return new DiffResult(name, compare(valueLeft, valueRight));
    }

    private DiffResult.Difference compare(V left, V right)
    {
        if (left == null && right == null)
        {
            return DiffResult.Difference.BOTH_NULL;
        }
        if (left == null)
        {
            return DiffResult.Difference.LEFT_NULL;
        }
        if (right == null)
        {
            return DiffResult.Difference.RIGHT_NULL;
        }
        if (left == right)
        {
            return DiffResult.Difference.SAME;
        }
        if (left instanceof Comparable && right instanceof Comparable)
        {
            return ((Comparable)(left)).compareTo((Comparable)right) == 0 ?
                    DiffResult.Difference.SAME :
                    DiffResult.Difference.DIFFERENT;
        }
        // Pluggable from here on (may be Type)
        String sleft = left.toString();
        String sright = right.toString();
        return sleft.equals(sright) ?
                DiffResult.Difference.SAME :
                DiffResult.Difference.DIFFERENT;
    }


    public void setPropertySource(PropertySource<T, V> propertySource)
    {
        this.propertySource = propertySource;
    }

    public void setName(String name)
    {
        this.name = name;
    }
}
