package net.sf.javaprinciples.data.transformer;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;
import org.omg.uml.Property;

import au.com.sparxsystems.Association;
import net.sf.jcc.model.parser.UnexpectedException;
import net.sf.jcc.model.parser.uml2.ElementStore;
import net.sf.jcc.model.parser.uml2.ModelElement;

/**
 * Transformer to transform from an input object to an output object given a
 * source model element and a target model element.
 *
 * @author Kay Chevalier
 */
public class ModelElementTransformer<Input, Output> implements Transformer<Input, Output>
{
    private ModelElement sourceModelElement;
    private ModelElement targetModelElement;
    private ElementStore store;

    private ObjectTypeMapper objectTypeMapper;

    public Output transform(Input input)
    {
        Object returnOutput = ModelElementMapperHelper.createObjectFromClassModelElement(targetModelElement, store, objectTypeMapper);

        List<Property> targetModelAttributes = ((org.omg.uml.Class)targetModelElement.getElement()).getOwnedAttribute();
        for (Property targetProperty : targetModelAttributes)
        {
            ModelElement targetPropertyElement = (ModelElement)store.reverse(targetProperty);
            List<Association> targetPropertyAssociations = targetPropertyElement.getAssociations();
            if (targetPropertyAssociations == null)
            {
                continue;
            }

            for (Association association : targetPropertyAssociations)
            {
                ModelElement sourceModelElement = store.get(association.getTargetAttributeId());
                Object sourceElement = sourceModelElement.getElement();
                if (sourceElement instanceof Property)
                {
                    String targetElementName = targetProperty.getName();
                    String sourceElementName = ((Property) sourceElement).getName();
                    Object sourceElementValue = getProperty(input, sourceElementName);
                    setProperty(returnOutput, targetElementName, sourceElementValue);
                }
            }
        }

        return (Output)returnOutput;
    }

    private void setProperty(Object returnOutput, String targetElementName, Object sourceElementValue)
    {
        try
        {
            BeanUtils.setProperty(returnOutput, targetElementName, sourceElementValue);
        }
        catch (IllegalAccessException e)
        {
            throw new UnexpectedException(e.getMessage(), e.getCause());
        }
        catch (InvocationTargetException e)
        {
            throw new UnexpectedException(e.getMessage(), e.getCause());
        }
}


    private Object getProperty(Object input, String sourceElementName)
    {
        try
        {
            return BeanUtils.getProperty(input, sourceElementName);
        }
        catch (IllegalAccessException e)
        {
            throw new UnexpectedException(e.getMessage(), e.getCause());
        }
        catch (InvocationTargetException e)
        {
            throw new UnexpectedException(e.getMessage(), e.getCause());
        }
        catch (NoSuchMethodException e)
        {
            throw new UnexpectedException(e.getMessage(), e.getCause());
        }
    }

    public void setSourceModelElement(ModelElement sourceModelElement)
    {
        this.sourceModelElement = sourceModelElement;
    }

    public void setTargetModelElement(ModelElement targetModelElement)
    {
        this.targetModelElement = targetModelElement;
    }

    public void setStore(ElementStore store)
    {
        this.store = store;
    }

    public void setObjectTypeMapper(ObjectTypeMapper objectTypeMapper)
    {
        this.objectTypeMapper = objectTypeMapper;
    }
}
