package net.sf.javaprinciples.data.transformer;

import net.sf.javaprinciples.data.visitor.Node;
import net.sf.javaprinciples.data.visitor.Visitor;
import net.sf.javaprinciples.data.visitor.VisitorImpl;

/**
 *
 * @author Warwick Slade
 */
public class DiffRoot<T> implements Diff<T>
{
    private Node node;

    @Override
    public DiffResult diff(T left, T right)
    {
        Visitor visitor = new VisitorImpl(left);
        visitor.addOperand(right);

        node.accept(visitor);
        return (DiffResult)visitor.getOperands()[2];
    }

    public void setNode(Node node)
    {
        this.node = node;
    }
}
