package net.sf.javaprinciples.data.transformer;

import net.sf.javaprinciples.data.visitor.ResultPolicy;
import net.sf.javaprinciples.data.visitor.Visitor;

/**
 * @author Warwick Slade
 */
public class DiffResultPolicy implements ResultPolicy<DiffResult>
{
    @Override
    public void result(Visitor visitor, DiffResult result)
    {
        Object[] operands = visitor.getOperands();
        DiffResult previous = (DiffResult) operands[operands.length - 1];
        previous.add(result);
    }
}
