package net.sf.javaprinciples.data.transformer;

/**
 * Default mapper to map the source attribute to the target attribute.
 *
 * @author Kay Chevalier
 */
public class DefaultAttributeMapper<T, U> extends ModelElementMapper<T, U>
{
    private ModelElementSourceDestinationMapper sourceModelElementMapper;
    private ModelElementSourceDestinationMapper destinationModelElementMapper;

    @Override
    public void map(T input, U output)
    {
        String targetAttributeName = destinationModelElementMapper.getAttributeName(getDestinationModelElements());
        String sourceAttributeName = sourceModelElementMapper.getAttributeName(getSourceModelElements());

        Object inputObjectValue;
        try
        {
            inputObjectValue = sourceModelElementMapper.getAttributeFromObject(getSourceModelElements(), input);
        }
        catch (AttributeNotFoundException e)
        {
            logAttributeMapping(input.getClass().getName(), sourceAttributeName, output.getClass().getName(), targetAttributeName, "Attribute Not Found");
            throw e;
        }

        logAttributeMapping(input.getClass().getName(), sourceAttributeName, output.getClass().getName(), targetAttributeName, inputObjectValue);
        destinationModelElementMapper.setAttributeOnParentObject(getDestinationModelElements(), inputObjectValue, output);
    }

    public void setSourceModelElementMapper(ModelElementSourceDestinationMapper sourceModelElementMapper)
    {
        this.sourceModelElementMapper = sourceModelElementMapper;
    }

    public void setDestinationModelElementMapper(ModelElementSourceDestinationMapper destinationModelElementMapper)
    {
        this.destinationModelElementMapper = destinationModelElementMapper;
    }
}
