package net.sf.javaprinciples.data.transformer;

/**
 *
 * @author Warwick Slade
 */
public class ClassObjectFactory<T> implements ObjectFactory
{
    private Class<T> clazz;


    @Override
    public Object create()
    {
        try
        {
            return clazz.newInstance();
        }
        catch (InstantiationException e)
        {
            throw new RuntimeException("Could not instantiate class", e);
        }
        catch (IllegalAccessException e)
        {
            throw new RuntimeException("Illegal access to class", e);
        }
    }

    public void setClazz(Class<T> clazz)
    {
        this.clazz = clazz;
    }
}
