package net.sf.javaprinciples.data.transformer;

/**
 * A simple mapper to delegate the attribute mapping to its list of mappers.
 *
 * @author Kay Chevalier
 */
public class AttributeMapper<T, U> extends ModelElementMapper<T, U>
{
    @Override
    public void map(T input, U output)
    {
        boolean attributeSet = false;

        for (Mapper mapper : getModelElementMappers())
        {
            try
            {
                mapper.map(input, output);
                attributeSet = true;
            } catch (AttributeNotFoundException e)
            {
                continue;
            }
        }

        if(!attributeSet)
        {
            throw new AttributeNotFoundException(String.format("No attributes have been found for mapping input %s to output %s",
                    input.getClass().getName(), output.getClass().getName()));
        }
    }
}
