package net.sf.javaprinciples.data.property;

import java.util.Collection;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.convert.ConversionService;

import net.sf.javaprinciples.data.property.PropertyTarget;

/**
 * Set properties on a target using spring utils
 *
 * @author Warwick Slade
 */
public class BeanPropertyTarget<U> implements PropertyTarget<Object, U>
{
    private String propertyName;
    private boolean destinationIsCollection;
    private ConversionService conversionService;

    @Override
    public void setProperty(Object target, U value)
    {
        if (target == null)
        {
            return;
        }

        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess(target);
        if (destinationIsCollection)
        {
            Collection<Object> collection = (Collection<Object>)wrapper.getPropertyValue(propertyName);
            collection.add(value);
        }
        else
        {
            if (conversionService != null)
            {
                wrapper.setConversionService(conversionService);
            }
//            if (value instanceof Enum)
//            {
//                value = ((Enum)value).toString();
//            }
            wrapper.setPropertyValue(propertyName, value);
        }
    }

    public void setPropertyName(String propertyName)
    {
        this.propertyName = propertyName;
    }

    public void setDestinationIsCollection(boolean destinationIsCollection)
    {
        this.destinationIsCollection = destinationIsCollection;
    }

    public void setConversionService(ConversionService conversionService)
    {
        this.conversionService = conversionService;
    }
}
