package net.sf.javaprinciples.data.property;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessorFactory;

/**
 * Use Spring bean helpers to obtain a property
 *
 * @author Warwick Slade
 */
public class BeanPropertySource<T> implements PropertySource<Object, T>
{
    private String propertyName;

    @Override
    public T getProperty(Object input)
    {
        if (input == null)
        {
            return null;
        }

        try
        {
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess(input);
            return (T)wrapper.getPropertyValue(propertyName);
        }
        catch (NullValueInNestedPathException e)
        {
            // no property diff
            return null;
        }
//        catch (NestedNullException e)
//        {
//            // no property diff
//            return null;
//        }
        catch (NotReadablePropertyException e)
        {
            // no property diff
            return null;
        }
    }

    public void setPropertyName(String propertyName)
    {
        this.propertyName = propertyName;
    }
}
