package net.sf.itcb.common.portlet.vaadin.page.impl;

import java.io.Serializable;

import net.sf.itcb.common.business.core.ItcbApplicationContextHolder;
import net.sf.itcb.common.portlet.vaadin.component.ItcbComponent;
import net.sf.itcb.common.portlet.vaadin.component.ItcbController;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Implementation of PageMappingProcessor for an additional window
 * 
 * @author Pierre Le Roux
 *
 */
public class WindowPageMappingProcessorImpl extends PageMappingProcessorImpl implements Serializable {

	private static final long serialVersionUID = 1L;
	
	protected final Logger log = LoggerFactory.getLogger(getClass());
		
	// Functions
	
	@Override
	public void displayPage(String refPage, ReloadOrder reload) {
		log.debug("displayPage {} {}" , refPage, reload);
			if(reload != null) {
				changePage(refPage, reload);
			}	
	}
	
	@Override
	public void displayDefaultPage() throws Exception {
		log.debug("Display the default page");
		if(defaultPageKey != null) {
			ItcbComponent component=  mapping.get(defaultPageKey);
			if(component == null) {
				synchronized (mapping) {
					component = ItcbApplicationContextHolder.getContext().getBean(pageMappingProcessorConfig.getMappingReferences().get(defaultPageKey), ItcbComponent.class);
					mapping.put(defaultPageKey, component);
				}
			}
			if(component instanceof ItcbController) {
				component.setPageMappingProcessor(this);
				component.init();
			}
			else {
				displayPage(defaultPageKey, ReloadOrder.TRUE);
			}
		}
		else {
			if(log.isDebugEnabled()) {
				log.warn("No default page configured. PageMappingProcessor mecanism not used. Set the defaultPageKey property in your spring context.");
			}
		}
	}
	
	@Override
	public void displayPreviousPage() {
		if(currentPageRef != null) {
			displayPage(currentPageRef, ReloadOrder.FALSE);
		}
		else {
			window.setVisible(false);
		}
	}
	


	
	


	


	
	
	
	
}
