package net.sf.itcb.common.portlet.vaadin.page.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.Panel;

/**
 * Implementation of PageMappingProcessor in order to have a CustomLayout around the panel in which pages are going to change
 * 
 * @author Pierre Le Roux
 */
public abstract class AbstractCustomLayoutPageMappingProcessorImpl extends PageMappingProcessorImpl {

	private static final long serialVersionUID = 1L;
	
	protected final Logger log = LoggerFactory.getLogger(getClass());
	
	private CustomLayout customLayout;
	
	private String templateContents;

	private String location;
	
	Panel contentContainer;
	
	public void setCustomLayoutTemplateContents(String templateContents) {
		this.templateContents=templateContents;
	}
	
	public void setContentContainerLocation(String location) {
		this.location = location;
	}
	
	
	@Override
	protected ComponentContainer initLayout() {
		customLayout = new CustomLayout("");
		customLayout.setTemplateContents(templateContents);
		
		defineLayoutContent();
		// 
		contentContainer = new Panel();
		customLayout.addComponent(contentContainer, location);
		return customLayout;
	}

	protected abstract void defineLayoutContent();

	@Override
	protected ComponentContainer getLayout() {
		return customLayout;
	}

	@Override
	protected ComponentContainer getContentContainer() {
		return contentContainer;
	}
	
	
	
}
