package net.sf.itcb.common.portlet.vaadin.page.config;

import java.util.List;
import java.util.Map;

import net.sf.itcb.common.portlet.vaadin.exception.ExceptionHandlerMapping;
import net.sf.itcb.common.portlet.vaadin.interceptor.page.ChangePageInterceptor;

/**
 * PageMappingProcessor configuration that should be injected by Spring bean.<br/>
 * It allows to declare how PageMappingProcessor is going to deal with exceptions, what filters have to be used when pages change...
 * @author Pierre Le Roux
 * @since 0.5.0
 */
public class PageMappingProcessorConfig {
	
	protected ExceptionHandlerMapping exceptionHandlerMapping;
	
	private List<ChangePageInterceptor> changePageInterceptors;

	protected boolean authorizeDirectAccessToFragmentOnLoad=false;
	
	private Map<String, String> mappingReferences;

	public ExceptionHandlerMapping getExceptionHandlerMapping() {
		return exceptionHandlerMapping;
	}

	/**
	 * This mapping can be set by Spring in order to use specific mecanisms to display errors.
	 * It can be interesting if you want to globalize your exception management
	 * @param exceptionHandlerMapping
	 */
	public void setExceptionHandlerMapping(
			ExceptionHandlerMapping exceptionHandlerMapping) {
		this.exceptionHandlerMapping = exceptionHandlerMapping;
	}

	public List<ChangePageInterceptor> getChangePageInterceptors() {
		return changePageInterceptors;
	}

	/**
	 * Interceptors that have to be called each time the user change the page to display
	 * @param changePageInterceptors list of interceptors
	 */
	public void setChangePageInterceptors(List<ChangePageInterceptor> changePageInterceptors) {
		this.changePageInterceptors = changePageInterceptors;
	}

	public boolean isAuthorizeDirectAccessToFragmentOnLoad() {
		return authorizeDirectAccessToFragmentOnLoad;
	}

	/**
	 * Defines if it is allowed to deal with fragment at application initialization.
	 * Applications which authorize it must deal with context in order to avoid not set variables...
	 * Application which unauthorize it, redirects the user on the same page or on the default page
	 * Default : false ==> Must be activated in Spring context
	 */
	public void setAuthorizeDirectAccessToFragmentOnLoad(
			boolean authorizeDirectAccessToFragmentOnLoad) {
		this.authorizeDirectAccessToFragmentOnLoad = authorizeDirectAccessToFragmentOnLoad;
	}

	public Map<String, String> getMappingReferences() {
		return mappingReferences;
	}

	/**
	 * Defines the mapping between key used by pages to navigate (with displayPage function...) and the spring bean name for implementation of a page
	 * @param mappingReferences a Map of String, String
	 */
	public void setMappingReferences(Map<String, String> mappingReferences) {
		this.mappingReferences = mappingReferences;
	}
	
	
	

}
